/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import marytts.signalproc.analysis.Label;

public class AlignLabelsUtils {
    public static int[][] alignLabels(Label[] labs1, Label[] labs2, double PDeletion, double PInsertion, double PSubstitution) {
        double z;
        int j;
        int i;
        double PCorrect = 1.0 - (PDeletion + PInsertion + PSubstitution);
        int n = labs1.length;
        int m = labs2.length;
        int[][] labelMap = null;
        if (n == 0 || m == 0) {
            double D = m;
            return labelMap;
        }
        double[][] d = new double[n + 1][m + 1];
        for (i = 0; i < d.length; ++i) {
            for (j = 0; j < d[i].length; ++j) {
                d[i][j] = 0.0;
            }
        }
        int[][] p = new int[n + 1][m + 1];
        for (i = 0; i < p.length; ++i) {
            for (j = 0; j < p[i].length; ++j) {
                p[i][j] = 0;
            }
        }
        d[0][0] = z = 1.0;
        for (i = 1; i <= n; ++i) {
            d[i][0] = d[i - 1][0] * PDeletion;
        }
        for (j = 1; j <= m; ++j) {
            d[0][j] = d[0][j - 1] * PInsertion;
        }
        String strEvents = "DISC";
        for (i = 1; i <= n; ++i) {
            for (j = 1; j <= m; ++j) {
                double c = labs1[i - 1].phn.compareTo(labs2[j - 1].phn) == 0 ? PCorrect : PSubstitution;
                int ind = 1;
                d[i][j] = d[i - 1][j] * PDeletion;
                double tmp = d[i][j - 1] * PInsertion;
                if (tmp > d[i][j]) {
                    d[i][j] = tmp;
                    ind = 2;
                }
                if ((tmp = d[i - 1][j - 1] * c) > d[i][j]) {
                    d[i][j] = tmp;
                    ind = 3;
                }
                if (ind == 3 && labs1[i - 1].phn.compareTo(labs2[j - 1].phn) == 0) {
                    ind = 4;
                }
                p[i][j] = ind;
            }
        }
        double D = d[n][m];
        int k = 1;
        int[] E = new int[m * n];
        E[k - 1] = p[n][m];
        i = n + 1;
        j = m + 1;
        int t = m;
        while (true) {
            if (E[k - 1] == 3 || E[k - 1] == 4) {
                --i;
                --j;
            } else if (E[k - 1] == 2) {
                --j;
            } else if (E[k - 1] == 1) {
                --i;
            }
            if (p[i - 1][j - 1] == 0) {
                while (j > 1) {
                    --j;
                    E[++k - 1] = 2;
                }
                break;
            }
            E[++k - 1] = p[i - 1][j - 1];
            --t;
        }
        int[] Events = new int[k];
        for (t = k; t >= 1; --t) {
            Events[t - 1] = E[k - t];
        }
        int[][] tmpLabelMap = new int[n * m][2];
        int ind = 0;
        int ind1 = 0;
        int ind2 = 0;
        for (t = 1; t <= k; ++t) {
            if (Events[t - 1] == 3 || Events[t - 1] == 4) {
                tmpLabelMap[ind][0] = ind1++;
                tmpLabelMap[ind][1] = ind2++;
                ++ind;
                continue;
            }
            if (Events[t - 1] == 1) {
                ++ind1;
                continue;
            }
            if (Events[t - 1] != 2) continue;
            ++ind2;
        }
        if (ind > 0) {
            labelMap = new int[ind][2];
            for (i = 0; i < labelMap.length; ++i) {
                labelMap[i][0] = tmpLabelMap[i][0];
                labelMap[i][1] = tmpLabelMap[i][1];
            }
        }
        return labelMap;
    }

    public static int[][] alignLabels(Label[] seq1, Label[] seq2) {
        return AlignLabelsUtils.alignLabels(seq1, seq2, 0.05, 0.05, 0.05);
    }
}

