/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.util.Arrays;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.math.ComplexArray;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class VocalTractModifier
implements InlineDataProcessor {
    protected int p;
    protected int fs;
    protected int fftSize;
    protected int maxFreq;
    protected ComplexArray h;
    protected double[] vtSpectrum;
    private ComplexArray expTerm;
    private boolean bAnalysisOnly;
    public static int tmpCount = 0;

    public VocalTractModifier() {
    }

    public VocalTractModifier(int pIn, int fsIn, int fftSizeIn) {
        this.initialise(pIn, fsIn, fftSizeIn);
    }

    public void initialise(int pIn, int fsIn, int fftSizeIn) {
        this.initialise(pIn, fsIn, fftSizeIn, false);
    }

    public void initialise(int pIn, int fsIn, int fftSizeIn, boolean bAnalysisOnlyIn) {
        this.p = pIn;
        this.fs = fsIn;
        this.fftSize = fftSizeIn;
        this.fftSize = MathUtils.closestPowerOfTwoAbove(this.fftSize);
        this.h = new ComplexArray(this.fftSize);
        this.maxFreq = SignalProcUtils.halfSpectrumSize(this.fftSize);
        this.vtSpectrum = new double[this.maxFreq];
        this.expTerm = new ComplexArray(this.p * this.maxFreq);
        this.expTerm = LpcAnalyser.calcExpTerm(this.fftSize, this.p);
        this.bAnalysisOnly = bAnalysisOnlyIn;
    }

    @Override
    public void applyInline(double[] data, int pos, int len) {
        assert (pos == 0);
        assert (len == data.length);
        ++tmpCount;
        if (len > this.fftSize) {
            len = this.fftSize;
        }
        if (len < this.fftSize) {
            double[] data2 = new double[this.fftSize];
            System.arraycopy(data, 0, data2, 0, data.length);
            Arrays.fill(data2, data.length, data2.length - 1, 0.0);
            data = new double[data2.length];
            System.arraycopy(data2, 0, data, 0, data2.length);
        }
        double origAvgEnergy = SignalProcUtils.getAverageSampleEnergy(data);
        LpcAnalyser.LpCoeffs coeffs = LpcAnalyser.calcLPC(data, this.p);
        double sqrtGain = coeffs.getGain();
        System.arraycopy(data, 0, this.h.real, 0, Math.min(len, this.h.real.length));
        if (this.h.real.length > len) {
            Arrays.fill(this.h.real, this.h.real.length - len, this.h.real.length - 1, 0.0);
        }
        Arrays.fill(this.h.imag, 0, this.h.imag.length - 1, 0.0);
        FFT.transform(this.h.real, this.h.imag, false);
        this.vtSpectrum = LpcAnalyser.calcSpecLinear(coeffs.getA(), this.p, this.fftSize, this.expTerm);
        int k = 0;
        while (k < this.maxFreq) {
            int n = k++;
            this.vtSpectrum[n] = this.vtSpectrum[n] * sqrtGain;
        }
        for (k = 0; k < this.maxFreq; ++k) {
            int n = k;
            this.h.real[n] = this.h.real[n] / this.vtSpectrum[k];
            int n2 = k;
            this.h.imag[n2] = this.h.imag[n2] / this.vtSpectrum[k];
        }
        if (!this.bAnalysisOnly) {
            this.processSpectrum(this.vtSpectrum);
            for (k = 0; k < this.maxFreq; ++k) {
                int n = k;
                this.h.real[n] = this.h.real[n] * this.vtSpectrum[k];
                int n3 = k;
                this.h.imag[n3] = this.h.imag[n3] * this.vtSpectrum[k];
            }
            for (k = this.maxFreq; k < this.fftSize; ++k) {
                this.h.real[k] = this.h.real[2 * this.maxFreq - k];
                this.h.imag[k] = -1.0 * this.h.imag[2 * this.maxFreq - k];
            }
            FFT.transform(this.h.real, this.h.imag, true);
            double newAvgEnergy = SignalProcUtils.getAverageSampleEnergy(this.h.real, len);
            double scale = origAvgEnergy / newAvgEnergy;
            k = 0;
            while (k < len) {
                int n = k++;
                this.h.real[n] = this.h.real[n] * scale;
            }
            System.arraycopy(this.h.real, 0, data, 0, len);
        }
    }

    protected void processSpectrum(double[] Px) {
    }
}

