/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.analysis.EnergyAnalyser;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.display.FunctionGraph;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;

public class EnergyGraph
extends FunctionGraph {
    public EnergyGraph(AudioInputStream ais) {
        this(ais, 640, 480);
    }

    public EnergyGraph(AudioInputStream ais, int width, int height) {
        if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
        }
        if (ais.getFormat().getChannels() > 1) {
            throw new IllegalArgumentException("Can only deal with mono audio signals");
        }
        int samplingRate = (int)ais.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
        this.initialise(signal, samplingRate, width, height);
    }

    public EnergyGraph(double[] signal, int samplingRate) {
        this(signal, samplingRate, 640, 480);
    }

    public EnergyGraph(double[] signal, int samplingRate, int width, int height) {
        this.initialise(new BufferedDoubleDataSource(signal), samplingRate, width, height);
    }

    protected void initialise(DoubleDataSource signal, int samplingRate, int width, int height) {
        double frameDuration = 0.01;
        int frameLength = (int)((double)samplingRate * frameDuration);
        int frameShift = frameLength / 2;
        if (frameLength % 2 == 0) {
            ++frameLength;
        }
        EnergyAnalyser energyAnalyser = new EnergyAnalyser(signal, frameLength, frameShift, samplingRate);
        FrameBasedAnalyser.FrameAnalysisResult<T>[] results = energyAnalyser.analyseAllFrames();
        double[] energyData = new double[results.length];
        for (int i = 0; i < results.length; ++i) {
            energyData[i] = (Double)results[i].get();
        }
        super.initialise(width, height, 0.0, (double)frameShift / (double)samplingRate, energyData);
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[i]));
            EnergyGraph signalGraph = new EnergyGraph(ais);
            signalGraph.showInJFrame(args[i], true, false);
        }
    }
}

