/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.SynthesisException;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureRegistry;
import marytts.modules.InternalModule;
import marytts.modules.acoustic.Model;
import marytts.modules.acoustic.ProsodyElementHandler;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.Voice;
import marytts.unitselection.select.UnitSelector;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class AcousticModeller
extends InternalModule {
    public AcousticModeller() {
        this((Locale)null);
    }

    public AcousticModeller(String locale) {
        this(MaryUtils.string2locale(locale));
    }

    public AcousticModeller(Locale locale) {
        super("AcousticModeller", MaryDataType.ALLOPHONES, MaryDataType.ACOUSTPARAMS, locale);
    }

    public AcousticModeller(String locale, String propertyPrefix) throws Exception {
        this(MaryUtils.string2locale(locale), propertyPrefix, FeatureRegistry.getFeatureProcessorManager(MaryUtils.string2locale(locale)));
    }

    public AcousticModeller(String locale, String propertyPrefix, String featprocClassInfo) throws Exception {
        this(MaryUtils.string2locale(locale), propertyPrefix, (FeatureProcessorManager)MaryRuntimeUtils.instantiateObject(featprocClassInfo));
    }

    protected AcousticModeller(Locale locale, String propertyPrefix, FeatureProcessorManager featureProcessorManager) {
        super("AcousticModeller", MaryDataType.ALLOPHONES, MaryDataType.ACOUSTPARAMS, locale);
    }

    @Override
    public MaryData process(MaryData d) throws SynthesisException {
        Document doc = d.getDocument();
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        Element voiceElement = (Element)doc.getElementsByTagName("voice").item(0);
        Voice voice = Voice.getVoice(voiceElement);
        if (voice == null) {
            voice = d.getDefaultVoice();
        }
        if (voice == null) {
            Locale locale = MaryUtils.string2locale(doc.getDocumentElement().getAttribute("xml:lang"));
            voice = Voice.getDefaultVoice(locale);
        }
        if (voice == null) {
            this.logger.debug("No voice found for locale; could not process!");
            output.setDocument(doc);
            return output;
        }
        assert (voice != null);
        Map<String, Model> models = voice.getAcousticModels();
        if (models == null) {
            this.logger.debug("No acoustic models defined in " + voice.getName() + "; could not process!");
            output.setDocument(doc);
            return output;
        }
        assert (models != null);
        Map<String, List<Element>> elementLists = this.parseDocument(doc);
        Model durationModel = voice.getDurationModel();
        if (durationModel == null) {
            throw new SynthesisException("No duration model available for voice " + voice);
        }
        List<Element> durationElements = elementLists.get(durationModel.getApplyTo());
        if (durationElements == null) {
            throw new SynthesisException("Could not determine to which Elements to apply duration model!");
        }
        try {
            durationModel.applyTo(durationElements);
        }
        catch (MaryConfigurationException e) {
            throw new SynthesisException("Duration model could not be applied", e);
        }
        this.hackSegmentDurations(durationElements);
        Model f0Model = voice.getF0Model();
        if (f0Model == null) {
            throw new SynthesisException("No F0 model available for voice " + voice);
        }
        try {
            List<Element> predictFromElements = elementLists.get(f0Model.getPredictFrom());
            List<Element> applyToElements = elementLists.get(f0Model.getApplyTo());
            if (predictFromElements == null || applyToElements == null) {
                throw new SynthesisException("Could not determine to which Elements to apply F0 model!");
            }
            f0Model.applyFromTo(predictFromElements, applyToElements);
        }
        catch (MaryConfigurationException e) {
            throw new SynthesisException("Could not apply F0 model", e);
        }
        Model boundaryModel = voice.getBoundaryModel();
        if (boundaryModel == null) {
            throw new SynthesisException("No boundary model available for voice " + voice);
        }
        try {
            List<Element> boundaryElements = elementLists.get(boundaryModel.getApplyTo());
            if (boundaryElements == null) {
                throw new SynthesisException("Could not determine to which Elements to apply boundary model!");
            }
            voice.getBoundaryModel().applyTo(boundaryElements);
        }
        catch (MaryConfigurationException e) {
            throw new SynthesisException("Could not apply boundary model", e);
        }
        Map<String, Model> otherModels = voice.getOtherModels();
        if (otherModels != null && !otherModels.isEmpty()) {
            for (String modelName : otherModels.keySet()) {
                Model model = models.get(modelName);
                if (model == null) {
                    throw new SynthesisException("Cannot apply invalid model");
                }
                try {
                    List<Element> predictFromElements = elementLists.get(model.getPredictFrom());
                    List<Element> applyToElements = elementLists.get(model.getApplyTo());
                    if (predictFromElements == null || applyToElements == null) {
                        throw new SynthesisException("Could not determine to which Elements to apply model '" + modelName + "'");
                    }
                    model.applyFromTo(predictFromElements, applyToElements);
                }
                catch (MaryConfigurationException e) {
                    throw new SynthesisException("Could not apply model '" + modelName + "'", e);
                }
            }
        }
        this.logger.debug("\nApplying prosody modification if any:");
        ProsodyElementHandler prosodyHandler = new ProsodyElementHandler();
        prosodyHandler.process(doc);
        output.setDocument(doc);
        return output;
    }

    private void hackSegmentDurations(List<Element> elements) {
        assert (elements != null);
        float cumulEndInSeconds = 0.0f;
        for (Element segment : elements) {
            float durationInSeconds = Float.parseFloat(segment.getAttribute("d"));
            String endStr = Float.toString(cumulEndInSeconds += durationInSeconds);
            segment.setAttribute("end", endStr);
            String durationInMilliseconds = String.format("%.0f", Float.valueOf(durationInSeconds * 1000.0f));
            segment.setAttribute("d", durationInMilliseconds);
        }
    }

    private Map<String, List<Element>> parseDocument(Document doc) throws SynthesisException {
        Node node;
        HashMap<String, List<Element>> elementLists = new HashMap<String, List<Element>>();
        ArrayList<Element> segments = new ArrayList<Element>();
        ArrayList<Element> boundaries = new ArrayList<Element>();
        ArrayList<Element> firstVoicedSegments = new ArrayList<Element>();
        ArrayList<Element> firstVowels = new ArrayList<Element>();
        ArrayList<Element> lastVoicedSegments = new ArrayList<Element>();
        ArrayList<Element> voicedSegments = new ArrayList<Element>();
        TreeWalker treeWalker = null;
        try {
            treeWalker = MaryDomUtils.createTreeWalker((Node)doc, "syllable", "boundary");
        }
        catch (DOMException e) {
            throw new SynthesisException("Could not parse XML Document", e);
        }
        while ((node = treeWalker.nextNode()) != null) {
            assert (node != null);
            Element element = (Element)node;
            if (node.getNodeName().equals("boundary")) {
                boundaries.add(element);
                continue;
            }
            assert (node.getNodeName().equals("syllable"));
            AllophoneSet allophoneSet = null;
            try {
                allophoneSet = MaryRuntimeUtils.determineAllophoneSet(element);
            }
            catch (MaryConfigurationException e) {
                throw new SynthesisException("Could not determine AllophoneSet", e);
            }
            assert (allophoneSet != null);
            Element firstVoicedSegment = null;
            Element firstVowel = null;
            Element lastVoicedSegment = null;
            Element segment = MaryDomUtils.getFirstElementByTagName(node, "ph");
            while (segment != null) {
                assert (segment != null);
                segments.add(segment);
                String phone = UnitSelector.getPhoneSymbol(segment);
                if (phone.length() == 0) {
                    throw new SynthesisException("No phone found for segment " + segment);
                }
                Allophone allophone = allophoneSet.getAllophone(phone);
                if (allophone == null) {
                    throw new SynthesisException("No Allophone found for phone '" + phone + "'");
                }
                if (allophone.isVoiced()) {
                    voicedSegments.add(segment);
                    if (firstVoicedSegment == null) {
                        firstVoicedSegment = segment;
                    }
                    if (firstVowel == null && allophone.isVowel()) {
                        firstVowel = segment;
                    }
                    lastVoicedSegment = segment;
                }
                segment = MaryDomUtils.getNextOfItsKindIn(segment, element);
            }
            if (firstVoicedSegment == null || firstVowel == null || lastVoicedSegment == null) {
                this.logger.debug("WARNING: could not identify F0 anchors in malformed syllable: '" + element.getAttribute("ph") + "'");
                continue;
            }
            firstVoicedSegments.add(firstVoicedSegment);
            firstVowels.add(firstVowel);
            lastVoicedSegments.add(lastVoicedSegment);
        }
        elementLists.put("segments", segments);
        elementLists.put("voicedSegments", voicedSegments);
        elementLists.put("firstVoicedSegments", firstVoicedSegments);
        elementLists.put("firstVowels", firstVowels);
        elementLists.put("lastVoicedSegments", lastVoicedSegments);
        elementLists.put("boundaries", boundaries);
        return elementLists;
    }
}

