/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.distribution;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.distribution.Distribution;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteDistribution
implements Distribution {
    private static final long serialVersionUID = 7573474548080998479L;
    private String attributeName;
    private double[] probabilities;
    private String[] valueNames;

    public DiscreteDistribution(String attributeName, double[] probabilities, String[] valueNames) {
        this.attributeName = attributeName;
        this.probabilities = probabilities;
        this.valueNames = valueNames;
    }

    @Override
    public final boolean isDiscrete() {
        return true;
    }

    @Override
    public final boolean isContinuous() {
        return false;
    }

    @Override
    public double getProbability(double value) {
        int index = (int)value;
        if (index >= 0 && index < this.probabilities.length) {
            return this.probabilities[index];
        }
        return Double.NaN;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public Collection<Double> getValues() {
        ArrayList<Double> values = new ArrayList<Double>();
        int i = 0;
        while (i < this.probabilities.length) {
            values.add(Double.valueOf(i));
            ++i;
        }
        return values;
    }

    @Override
    public String mapValue(double value) {
        int index = (int)value;
        if (index >= 0 && index < this.valueNames.length) {
            return this.valueNames[index];
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer distributionDescription = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < this.valueNames.length) {
            if (!first) {
                distributionDescription.append("\t");
            }
            distributionDescription.append(this.valueNames[i]);
            first = false;
            ++i;
        }
        first = true;
        distributionDescription.append(Tools.getLineSeparator());
        i = 0;
        while (i < this.valueNames.length) {
            if (!first) {
                distributionDescription.append("\t");
            }
            distributionDescription.append(Tools.formatNumber(this.probabilities[i]));
            first = false;
            ++i;
        }
        return distributionDescription.toString();
    }

    @Override
    public int getNumberOfParameters() {
        return this.valueNames.length;
    }

    @Override
    public String getParameterName(int index) {
        return "value=" + this.valueNames[index];
    }

    @Override
    public double getParameterValue(int index) {
        return this.probabilities[index];
    }
}

