/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.container;

import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.tools.container.Tupel;
import com.rapidminer.tools.math.container.BallTreeNode;
import com.rapidminer.tools.math.container.BoundedPriorityQueue;
import com.rapidminer.tools.math.container.GeometricDataCollection;
import com.rapidminer.tools.math.similarity.DistanceMeasure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BallTree<T extends Serializable>
implements GeometricDataCollection<T> {
    private static final long serialVersionUID = 2954882147712365506L;
    private BallTreeNode<T> root;
    private int k;
    private double dimensionFactor;
    private DistanceMeasure distance;
    private int size = 0;
    private ArrayList<T> values = new ArrayList();

    public BallTree(DistanceMeasure distance) {
        this.distance = distance;
    }

    @Override
    public void add(double[] values, T storeValue) {
        ++this.size;
        this.values.add(storeValue);
        if (this.root == null) {
            this.root = new BallTreeNode<T>(values, 0.0, storeValue);
            this.k = values.length;
            this.dimensionFactor = Math.sqrt(Math.PI) / Math.pow(this.gammaFunction(this.k / 2), 1.0 / (double)this.k);
        } else {
            double totalAncestorIncrease = 0.0;
            double bestVolumeIncrease = Double.POSITIVE_INFINITY;
            BallTreeNode<T> bestNode = null;
            int bestNodeIndex = 0;
            int bestSide = -1;
            BallTreeNode<T> currentNode = this.root;
            LinkedList<BallTreeNode<T>> ancestorList = new LinkedList<BallTreeNode<T>>();
            while (true) {
                double rightVolume;
                double deltaAncestorIncrease = this.getVolumeIncludingPoint(currentNode, values) - this.getVolume(currentNode);
                totalAncestorIncrease += deltaAncestorIncrease;
                double leftVolume = this.getNewVolume(currentNode, currentNode.getLeftChild(), values);
                double minVolume = Math.min(leftVolume, rightVolume = this.getNewVolume(currentNode, currentNode.getRightChild(), values));
                if (minVolume + totalAncestorIncrease < bestVolumeIncrease) {
                    bestVolumeIncrease = minVolume + totalAncestorIncrease;
                    bestNode = currentNode;
                    bestSide = Double.compare(leftVolume, rightVolume);
                    bestNodeIndex = ancestorList.size();
                }
                ancestorList.add(currentNode);
                if (currentNode.isLeaf()) break;
                if (currentNode.hasTwoChilds()) {
                    BallTreeNode<T> rightChild;
                    double deltaVRight;
                    BallTreeNode<T> leftChild = currentNode.getLeftChild();
                    double deltaVLeft = this.getVolumeIncludingPoint(leftChild, values) - this.getVolume(leftChild);
                    BallTreeNode<T> betterChild = deltaVLeft < (deltaVRight = this.getVolumeIncludingPoint(rightChild = currentNode.getRightChild(), values) - this.getVolume(rightChild)) ? leftChild : rightChild;
                    currentNode = betterChild;
                    continue;
                }
                currentNode = currentNode.getChild();
            }
            BallTreeNode<T> newNode = new BallTreeNode<T>(values, 0.0, storeValue);
            if (bestSide < 0) {
                newNode.setChild(bestNode.getLeftChild());
                bestNode.setLeftChild(newNode);
            } else {
                newNode.setChild(bestNode.getRightChild());
                bestNode.setRightChild(newNode);
            }
            if (!newNode.isLeaf()) {
                newNode.setRadius(this.distance.calculateDistance(values, newNode.getChild().getCenter()) + newNode.getChild().getRadius());
            }
            ListIterator iterator = ancestorList.listIterator(bestNodeIndex + 1);
            while (iterator.hasPrevious()) {
                BallTreeNode ancestor = (BallTreeNode)iterator.previous();
                if (ancestor.hasTwoChilds()) {
                    BallTreeNode leftChild = ancestor.getLeftChild();
                    BallTreeNode rightChild = ancestor.getRightChild();
                    ancestor.setRadius(Math.max(rightChild.getRadius() + this.distance.calculateDistance(rightChild.getCenter(), ancestor.getCenter()), leftChild.getRadius() + this.distance.calculateDistance(leftChild.getCenter(), ancestor.getCenter())));
                    continue;
                }
                BallTreeNode child = ancestor.getChild();
                ancestor.setRadius(this.distance.calculateDistance(ancestor.getCenter(), child.getCenter()) + child.getRadius());
            }
        }
    }

    private double getNewVolume(BallTreeNode<T> father, BallTreeNode<T> child, double[] center) {
        if (child == null) {
            return 0.0;
        }
        return Math.pow((this.distance.calculateDistance(center, child.getCenter()) + child.getRadius()) * this.dimensionFactor, this.k);
    }

    @Override
    public Collection<T> getNearestValues(int k, double[] values) {
        BoundedPriorityQueue<Tupel<Double, BallTreeNode<T>>> priorityQueue = this.getNearestNodes(k, values);
        LinkedList<Serializable> neighboursList = new LinkedList<Serializable>();
        for (Tupel tupel : priorityQueue) {
            neighboursList.add((Serializable)((BallTreeNode)tupel.getSecond()).getStoreValue());
        }
        return neighboursList;
    }

    @Override
    public Collection<Tupel<Double, T>> getNearestValueDistances(int k, double[] values) {
        BoundedPriorityQueue<Tupel<Double, BallTreeNode<T>>> priorityQueue = this.getNearestNodes(k, values);
        LinkedList<Tupel<Double, T>> neighboursList = new LinkedList<Tupel<Double, T>>();
        for (Tupel tupel : priorityQueue) {
            neighboursList.add(new Tupel<Double, Serializable>((Double)tupel.getFirst(), (Serializable)((BallTreeNode)tupel.getSecond()).getStoreValue()));
        }
        return neighboursList;
    }

    private BoundedPriorityQueue<Tupel<Double, BallTreeNode<T>>> getNearestNodes(int k, double[] values) {
        Stack<BallTreeNode<T>> nodeStack = new Stack<BallTreeNode<T>>();
        Stack<Integer> sideStack = new Stack<Integer>();
        this.traverseTree(nodeStack, sideStack, this.root, values);
        BoundedPriorityQueue<Tupel<Double, BallTreeNode<T>>> priorityQueue = new BoundedPriorityQueue<Tupel<Double, BallTreeNode<T>>>(k);
        while (!nodeStack.isEmpty()) {
            BallTreeNode<T> otherChild;
            BallTreeNode<T> currentNode = nodeStack.pop();
            Integer currentSide = sideStack.pop();
            Tupel<Double, BallTreeNode<T>> currentTupel = new Tupel<Double, BallTreeNode<T>>(this.distance.calculateDistance(currentNode.getCenter(), values), currentNode);
            priorityQueue.add(currentTupel);
            if (!currentNode.hasTwoChilds()) continue;
            BallTreeNode<T> ballTreeNode = otherChild = currentSide < 0 ? currentNode.getRightChild() : currentNode.getLeftChild();
            if (priorityQueue.isFilled() && !((Double)((Tupel)priorityQueue.peek()).getFirst() + otherChild.getRadius() > this.distance.calculateDistance(values, otherChild.getCenter()))) continue;
            this.traverseTree(nodeStack, sideStack, otherChild, values);
        }
        return priorityQueue;
    }

    private void traverseTree(Stack<BallTreeNode<T>> stack, Stack<Integer> sideStack, BallTreeNode<T> root, double[] values) {
        BallTreeNode<T> currentNode = root;
        stack.push(currentNode);
        while (!currentNode.isLeaf()) {
            if (currentNode.hasTwoChilds()) {
                double distanceRight;
                double distanceLeft = this.distance.calculateDistance(currentNode.getLeftChild().getCenter(), values);
                currentNode = distanceLeft < (distanceRight = this.distance.calculateDistance(currentNode.getRightChild().getCenter(), values)) ? currentNode.getLeftChild() : currentNode.getRightChild();
                sideStack.push(Double.compare(distanceLeft, distanceRight));
            } else {
                currentNode = currentNode.getChild();
                sideStack.push(0);
            }
            stack.push(currentNode);
        }
        sideStack.push(0);
    }

    private double getVolumeIncludingPoint(BallTreeNode node, double[] point) {
        return Math.pow(Math.max(node.getRadius(), this.distance.calculateDistance(point, node.getCenter())) * this.dimensionFactor, this.k);
    }

    private double getVolume(BallTreeNode node) {
        return Math.pow(node.getRadius() * this.dimensionFactor, this.k);
    }

    private double gammaFunction(int n) {
        double result = 1.0;
        int i = 2;
        while (i < n) {
            result *= (double)i;
            ++i;
        }
        return result;
    }

    public SimpleDataTable getVisualization() {
        SimpleDataTable table = new SimpleDataTable("BallTree", new String[]{"x", "y", "radius"});
        this.fillTable(table, this.root);
        return table;
    }

    private void fillTable(SimpleDataTable table, BallTreeNode<T> node) {
        table.add(new SimpleDataTableRow(new double[]{node.getCenter()[0], node.getCenter()[1], node.getRadius()}));
        if (node.hasLeftChild()) {
            this.fillTable(table, node.getLeftChild());
        }
        if (node.hasRightChild()) {
            this.fillTable(table, node.getRightChild());
        }
    }

    @Override
    public Collection<Tupel<Double, T>> getNearestValueDistances(double withinDistance, double[] values) {
        throw new RuntimeException("Not supported method");
    }

    @Override
    public Collection<Tupel<Double, T>> getNearestValueDistances(double withinDistance, int butAtLeastK, double[] values) {
        throw new RuntimeException("Not supported method");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int index) {
        return (T)((Serializable)this.values.get(index));
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }
}

