/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math;

import com.rapidminer.tools.math.Peak;
import com.rapidminer.tools.math.PeakFinder;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePeakFinder
implements PeakFinder {
    private int numberOfNeighbours = 5;

    public SimplePeakFinder(int neighbours) {
        this.numberOfNeighbours = neighbours;
    }

    @Override
    public List<Peak> getPeaks(Peak[] series) {
        LinkedList<Peak> result = new LinkedList<Peak>();
        int i = 0;
        while (i < series.length) {
            if (this.isPeak(series, i)) {
                result.add(series[i]);
            }
            ++i;
        }
        return result;
    }

    private boolean isPeak(Peak[] series, int index) {
        boolean ok = false;
        int current = index;
        int okValues = 0;
        while (!ok) {
            if (--current < 0) {
                return false;
            }
            if (!this.isOk(series, current, index)) {
                return false;
            }
            if (++okValues <= this.numberOfNeighbours) continue;
            ok = true;
        }
        ok = false;
        current = index;
        okValues = 0;
        while (!ok) {
            if (++current >= series.length) {
                return false;
            }
            if (!this.isOk(series, current, index)) {
                return false;
            }
            if (++okValues <= this.numberOfNeighbours) continue;
            ok = true;
        }
        return true;
    }

    private boolean isOk(Peak[] series, int current, int index) {
        return !(series[current].getMagnitude() <= series[index].getMagnitude());
    }
}

