/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.CombinedInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SpecificInnerOperatorCondition;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValidationChain
extends OperatorChain {
    public static final String PARAMETER_CREATE_COMPLETE_MODEL = "create_complete_model";
    private double lastMainPerformance = Double.NaN;
    private double lastMainVariance = Double.NaN;
    private double lastMainDeviation = Double.NaN;
    private double lastFirstPerformance = Double.NaN;
    private double lastSecondPerformance = Double.NaN;
    private double lastThirdPerformance = Double.NaN;
    private IOContainer learnResult;

    public ValidationChain(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("performance", "The last performance average (main criterion)."){

            public double getDoubleValue() {
                return ValidationChain.this.lastMainPerformance;
            }
        });
        this.addValue(new ValueDouble("variance", "The variance of the last performance (main criterion)."){

            public double getDoubleValue() {
                return ValidationChain.this.lastMainVariance;
            }
        });
        this.addValue(new ValueDouble("deviation", "The standard deviation of the last performance (main criterion)."){

            public double getDoubleValue() {
                return ValidationChain.this.lastMainDeviation;
            }
        });
        this.addValue(new ValueDouble("performance1", "The last performance average (first criterion)."){

            public double getDoubleValue() {
                return ValidationChain.this.lastFirstPerformance;
            }
        });
        this.addValue(new ValueDouble("performance2", "The last performance average (second criterion)."){

            public double getDoubleValue() {
                return ValidationChain.this.lastSecondPerformance;
            }
        });
        this.addValue(new ValueDouble("performance3", "The last performance average (third criterion)."){

            public double getDoubleValue() {
                return ValidationChain.this.lastThirdPerformance;
            }
        });
    }

    public abstract IOObject[] estimatePerformance(ExampleSet var1) throws OperatorException;

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 2;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 2;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        if (this.getParameterAsBoolean(PARAMETER_CREATE_COMPLETE_MODEL)) {
            return new Class[]{PerformanceVector.class, Model.class};
        }
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new SpecificInnerOperatorCondition("Training", 0, new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Testing", 1, new Class[]{ExampleSet.class, Model.class}, new Class[]{PerformanceVector.class}));
        return condition;
    }

    protected Operator getLearner() {
        return this.getOperator(0);
    }

    private Operator getEvaluator() {
        return this.getOperator(1);
    }

    protected final void setResult(PerformanceVector pv) {
        this.lastMainPerformance = Double.NaN;
        this.lastMainVariance = Double.NaN;
        this.lastMainDeviation = Double.NaN;
        this.lastFirstPerformance = Double.NaN;
        this.lastSecondPerformance = Double.NaN;
        this.lastThirdPerformance = Double.NaN;
        if (pv != null) {
            PerformanceCriterion criterion;
            PerformanceCriterion mainCriterion = pv.getMainCriterion();
            if (mainCriterion == null && pv.size() > 0) {
                mainCriterion = pv.getCriterion(0);
            }
            if (mainCriterion != null) {
                this.lastMainPerformance = mainCriterion.getAverage();
                this.lastMainVariance = mainCriterion.getVariance();
                this.lastMainDeviation = mainCriterion.getStandardDeviation();
            }
            if (pv.size() >= 1 && (criterion = pv.getCriterion(0)) != null) {
                this.lastFirstPerformance = criterion.getAverage();
            }
            if (pv.size() >= 2 && (criterion = pv.getCriterion(1)) != null) {
                this.lastSecondPerformance = criterion.getAverage();
            }
            if (pv.size() >= 3 && (criterion = pv.getCriterion(2)) != null) {
                this.lastThirdPerformance = criterion.getAverage();
            }
        }
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOObject[] estimation;
        ExampleSet eSet = this.getInput(ExampleSet.class);
        IOObject[] result = estimation = this.estimatePerformance(eSet);
        if (this.getParameterAsBoolean(PARAMETER_CREATE_COMPLETE_MODEL)) {
            Model model = this.learn(eSet).get(Model.class);
            result = new IOObject[estimation.length + 1];
            System.arraycopy(estimation, 0, result, 0, estimation.length);
            result[result.length - 1] = model;
        }
        return result;
    }

    protected IOContainer learn(ExampleSet trainingSet) throws OperatorException {
        this.learnResult = this.getLearner().apply(new IOContainer(trainingSet));
        return this.learnResult;
    }

    public IOContainer evaluate(ExampleSet testSet, IOContainer learnResult) throws OperatorException {
        if (learnResult == null) {
            throw new RuntimeException("Wrong use of ValidationChain.evaluate(ExampleSet): No preceding invocation of learn(ExampleSet)!");
        }
        Attribute predictedBefore = testSet.getAttributes().getPredictedLabel();
        IOContainer evalInput = learnResult.append(new IOObject[]{testSet});
        IOContainer result = this.getEvaluator().apply(evalInput);
        Attribute predictedAfter = testSet.getAttributes().getPredictedLabel();
        if (predictedAfter != null && (predictedBefore == null || predictedBefore.getTableIndex() != predictedAfter.getTableIndex())) {
            PredictionModel.removePredictedLabel(testSet);
        }
        return result;
    }

    protected IOContainer evaluate(ExampleSet testSet) throws OperatorException {
        if (this.learnResult == null) {
            throw new RuntimeException("Wrong use of ValidationChain.evaluate(ExampleSet): No preceding invocation of learn(ExampleSet)!");
        }
        IOContainer result = this.evaluate(testSet, this.learnResult);
        this.learnResult = null;
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_CREATE_COMPLETE_MODEL, "Indicates if a model of the complete data set should be additionally build after estimation.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

