/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.MappedExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.Ontology;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetMinus
extends Operator {
    public ExampleSetMinus(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet subtrahendSet = this.getInput(ExampleSet.class);
        ExampleSet minuendSet = this.getInput(ExampleSet.class);
        subtrahendSet.remapIds();
        minuendSet.remapIds();
        Attribute minuendId = minuendSet.getAttributes().getId();
        Attribute subtrahendId = subtrahendSet.getAttributes().getId();
        if (minuendId == null || subtrahendId == null) {
            throw new UserError(this, 129);
        }
        if (minuendId.getValueType() != subtrahendId.getValueType()) {
            throw new UserError((Operator)this, 120, subtrahendId.getName(), Ontology.VALUE_TYPE_NAMES[subtrahendId.getValueType()], Ontology.VALUE_TYPE_NAMES[minuendId.getValueType()]);
        }
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int i = 0;
        for (Example example : minuendSet) {
            double id = example.getValue(minuendId);
            Example subtrahendExample = null;
            subtrahendExample = minuendId.isNominal() ? subtrahendSet.getExampleFromId(subtrahendId.getMapping().getIndex(minuendId.getMapping().mapIndex((int)id))) : subtrahendSet.getExampleFromId(id);
            if (subtrahendExample == null) {
                indices.add(i);
            }
            ++i;
        }
        int[] indexArray = new int[indices.size()];
        int i2 = 0;
        while (i2 < indices.size()) {
            indexArray[i2] = (Integer)indices.get(i2);
            ++i2;
        }
        MappedExampleSet minusSet = new MappedExampleSet(minuendSet, indexArray);
        return new IOObject[]{minusSet};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class, ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        return types;
    }
}

