/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.join;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.DefaultIODescription;
import com.rapidminer.operator.IODescription;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetMerge
extends Operator {
    public static final String PARAMETER_MERGE_TYPE = "merge_type";
    public static final String[] MERGE_TYPES = new String[]{"all", "first_two"};
    public static final int MERGE_TYPE_ALL = 0;
    public static final int MERGE_TYPE_FIRST_TWO = 1;
    public static final String PARAMETER_DATAMANAGEMENT = "datamanagement";

    public ExampleSetMerge(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        LinkedList<ExampleSet> allExampleSets = new LinkedList<ExampleSet>();
        boolean found = true;
        while (found) {
            try {
                ExampleSet exampleSet = this.getInput(ExampleSet.class);
                allExampleSets.add(exampleSet);
            }
            catch (MissingIOObjectException e) {
                found = false;
            }
            if (this.getParameterAsInt(PARAMETER_MERGE_TYPE) != 1 || allExampleSets.size() < 2) continue;
            found = false;
        }
        if (allExampleSets.size() == 0) {
            throw new MissingIOObjectException(ExampleSet.class);
        }
        this.checkForCompatibility(allExampleSets);
        ExampleSet firstSet = (ExampleSet)allExampleSets.get(0);
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        HashMap<Attribute, String> specialAttributes = new HashMap<Attribute, String>();
        Iterator<AttributeRole> a = firstSet.getAttributes().allAttributeRoles();
        while (a.hasNext()) {
            AttributeRole role = a.next();
            Attribute attributeClone = (Attribute)role.getAttribute().clone();
            attributeList.add(attributeClone);
            if (!role.isSpecial()) continue;
            specialAttributes.put(attributeClone, role.getSpecialName());
        }
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributeList);
        Iterator i = allExampleSets.iterator();
        DataRowFactory factory = new DataRowFactory(this.getParameterAsInt(PARAMETER_DATAMANAGEMENT), '.');
        while (i.hasNext()) {
            ExampleSet currentExampleSet = (ExampleSet)i.next();
            Iterator e = currentExampleSet.iterator();
            while (e.hasNext()) {
                DataRow dataRow = ((Example)e.next()).getDataRow();
                String[] newData = new String[attributeList.size()];
                Iterator newAttributes = attributeList.iterator();
                int counter = 0;
                while (newAttributes.hasNext()) {
                    Attribute newAttribute = (Attribute)newAttributes.next();
                    Attribute oldAttribute = currentExampleSet.getAttributes().get(newAttribute.getName());
                    double oldValue = dataRow.get(oldAttribute);
                    newData[counter] = Double.isNaN(oldValue) ? "?" : (newAttribute.isNominal() ? oldAttribute.getMapping().mapIndex((int)oldValue) : String.valueOf(oldValue));
                    ++counter;
                }
                exampleTable.addDataRow(factory.create(newData, exampleTable.getAttributes()));
                this.checkForStop();
            }
        }
        ExampleSet resultSet = exampleTable.createExampleSet(specialAttributes);
        return new IOObject[]{resultSet};
    }

    private void checkForCompatibility(List<ExampleSet> allExampleSets) throws OperatorException {
        ExampleSet first = allExampleSets.get(0);
        Iterator<ExampleSet> i = allExampleSets.iterator();
        while (i.hasNext()) {
            this.checkForCompatibility(first, i.next());
        }
    }

    private void checkForCompatibility(ExampleSet first, ExampleSet second) throws OperatorException {
        if (first.getAttributes().allSize() != second.getAttributes().allSize()) {
            throw new UserError((Operator)this, 925, "numbers of attributes are different");
        }
        Iterator<Attribute> firstIterator = first.getAttributes().allAttributes();
        while (firstIterator.hasNext()) {
            Attribute firstAttribute = firstIterator.next();
            Attribute secondAttribute = second.getAttributes().get(firstAttribute.getName());
            if (secondAttribute != null) continue;
            throw new UserError((Operator)this, 925, "attribute with name '" + firstAttribute.getName() + "' is not part of second example set.");
        }
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class, ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    protected IODescription getIODescription() {
        boolean mergeAll = true;
        try {
            mergeAll = this.getParameterAsInt(PARAMETER_MERGE_TYPE) == 0;
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return new MergeIODescription(mergeAll);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_MERGE_TYPE, "Indicates if all input example sets or only the first two example sets should be merged.", MERGE_TYPES, 0));
        types.add(new ParameterTypeCategory(PARAMETER_DATAMANAGEMENT, "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MergeIODescription
    extends DefaultIODescription {
        private boolean mergeAll = true;

        public MergeIODescription(boolean mergeAll) {
            super(new Class[]{ExampleSet.class, ExampleSet.class}, new Class[]{ExampleSet.class});
            this.mergeAll = mergeAll;
        }

        @Override
        public Class<?>[] getOutputClasses(Class<?>[] input, Operator operator) throws IllegalInputException {
            LinkedList outputList = new LinkedList();
            int exampleSetCount = 0;
            int i = 0;
            while (i < input.length) {
                if (ExampleSet.class.isAssignableFrom(input[i])) {
                    if (!this.mergeAll && ++exampleSetCount >= 3) {
                        outputList.add(input[i]);
                    }
                } else {
                    outputList.add(input[i]);
                }
                ++i;
            }
            if (exampleSetCount >= 2) {
                outputList.add(ExampleSet.class);
            }
            if (outputList.size() == 0) {
                outputList.add(ExampleSet.class);
            }
            Class[] outputArray = new Class[outputList.size()];
            outputList.toArray(outputArray);
            return outputArray;
        }
    }
}

