/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.performance.ClassWeightedPerformance;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.operator.performance.PerformanceComparator;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.Ontology;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPerformanceEvaluator
extends Operator {
    public static final String PARAMETER_MAIN_CRITERION = "main_criterion";
    public static final String PARAMETER_SKIP_UNDEFINED_LABELS = "skip_undefined_labels";
    public static final String PARAMETER_COMPARATOR_CLASS = "comparator_class";
    private static final String PARAMETER_USE_EXAMPLE_WEIGHTS = "use_example_weights";
    private PerformanceVector currentPerformanceVector = null;

    public AbstractPerformanceEvaluator(OperatorDescription description) {
        super(description);
        List<PerformanceCriterion> criteria = this.getCriteria();
        for (PerformanceCriterion criterion : criteria) {
            this.addPerformanceValue(criterion.getName(), criterion.getDescription());
        }
        this.addValue(new ValueDouble("performance", "The last performance (main criterion)."){

            public double getDoubleValue() {
                if (AbstractPerformanceEvaluator.this.currentPerformanceVector != null) {
                    return AbstractPerformanceEvaluator.this.currentPerformanceVector.getMainCriterion().getAverage();
                }
                return Double.NaN;
            }
        });
    }

    public abstract List<PerformanceCriterion> getCriteria();

    protected abstract double[] getClassWeights(Attribute var1) throws UndefinedParameterError;

    protected abstract void checkCompatibility(ExampleSet var1) throws OperatorException;

    protected void init(ExampleSet exampleSet) {
    }

    protected boolean showSkipNaNLabelsParameter() {
        return true;
    }

    protected boolean showComparatorParameter() {
        return true;
    }

    protected boolean showCriteriaParameter() {
        return true;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet testSet = this.getInput(ExampleSet.class);
        this.checkCompatibility(testSet);
        this.init(testSet);
        PerformanceVector inputPerformance = null;
        try {
            inputPerformance = this.getInput(PerformanceVector.class);
        }
        catch (MissingIOObjectException missingIOObjectException) {
            // empty catch block
        }
        try {
            PerformanceVector performance = this.evaluate(testSet, inputPerformance);
            return new IOObject[]{performance};
        }
        catch (UserError e) {
            e.setOperator(this);
            throw e;
        }
    }

    private void addPerformanceValue(final String name, String description) {
        this.addValue(new ValueDouble(name, description){

            public double getDoubleValue() {
                if (AbstractPerformanceEvaluator.this.currentPerformanceVector == null) {
                    return Double.NaN;
                }
                PerformanceCriterion c = AbstractPerformanceEvaluator.this.currentPerformanceVector.getCriterion(name);
                if (c != null) {
                    return c.getAverage();
                }
                return Double.NaN;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PerformanceVector initialisePerformanceVector(ExampleSet testSet, PerformanceVector performanceCriteria, List<PerformanceCriterion> givenCriteria) throws OperatorException {
        String mcName;
        givenCriteria.clear();
        if (performanceCriteria == null) {
            performanceCriteria = new PerformanceVector();
        } else {
            int i = 0;
            while (i < performanceCriteria.getSize()) {
                givenCriteria.add(performanceCriteria.getCriterion(i));
                ++i;
            }
        }
        List<PerformanceCriterion> criteria = this.getCriteria();
        for (PerformanceCriterion criterion : criteria) {
            if (!this.checkCriterionName(criterion.getName())) continue;
            performanceCriteria.addCriterion(criterion);
        }
        if (performanceCriteria.size() == 0) {
            throw new UserError(this, 910);
        }
        if (performanceCriteria.size() == 0) {
            List<PerformanceCriterion> availableCriteria = this.getCriteria();
            if (availableCriteria.size() <= 0) {
                this.logWarning(String.valueOf(this.getName()) + ": not possible to identify available performance criteria.");
                throw new UserError(this, 910);
            }
            PerformanceCriterion criterion = availableCriteria.get(0);
            performanceCriteria.addCriterion(criterion);
            performanceCriteria.setMainCriterionName(criterion.getName());
            this.logWarning(String.valueOf(this.getName()) + ": No performance criterion selected! Using the first available criterion (" + criterion.getName() + ").");
        } else if (this.showCriteriaParameter() && (mcName = this.getParameterAsString(PARAMETER_MAIN_CRITERION)) != null) {
            performanceCriteria.setMainCriterionName(mcName);
        }
        String comparatorClass = null;
        if (this.showComparatorParameter()) {
            comparatorClass = this.getParameterAsString(PARAMETER_COMPARATOR_CLASS);
        }
        if (comparatorClass == null) {
            performanceCriteria.setComparator(new PerformanceVector.DefaultComparator());
            return performanceCriteria;
        }
        try {
            Class pcClass = Tools.classForName(comparatorClass);
            if (!PerformanceComparator.class.isAssignableFrom(pcClass)) {
                throw new UserError((Operator)this, 914, pcClass, PerformanceComparator.class);
            }
            performanceCriteria.setComparator((PerformanceComparator)pcClass.newInstance());
            return performanceCriteria;
        }
        catch (Throwable e) {
            throw new UserError((Operator)this, e, 904, comparatorClass, e);
        }
    }

    private boolean checkCriterionName(String name) throws UndefinedParameterError {
        String mainCriterionName = this.getParameterAsString(PARAMETER_MAIN_CRITERION);
        if (name != null && name.trim().length() != 0 && !name.equals("first") && name.equals(mainCriterionName)) {
            return true;
        }
        ParameterType type = this.getParameterType(name);
        if (type != null) {
            return this.getParameterAsBoolean(name);
        }
        return true;
    }

    protected PerformanceVector evaluate(ExampleSet testSet, PerformanceVector inputPerformance) throws OperatorException {
        LinkedList<PerformanceCriterion> givenCriteria = new LinkedList<PerformanceCriterion>();
        this.currentPerformanceVector = this.initialisePerformanceVector(testSet, inputPerformance, givenCriteria);
        boolean skipUndefined = true;
        if (this.showComparatorParameter()) {
            skipUndefined = this.getParameterAsBoolean(PARAMETER_SKIP_UNDEFINED_LABELS);
        }
        boolean useExampleWeights = this.getParameterAsBoolean(PARAMETER_USE_EXAMPLE_WEIGHTS);
        AbstractPerformanceEvaluator.evaluate(this, testSet, this.currentPerformanceVector, givenCriteria, skipUndefined, useExampleWeights);
        return this.currentPerformanceVector;
    }

    public static void evaluate(AbstractPerformanceEvaluator evaluator, ExampleSet testSet, PerformanceVector performanceCriteria, List<PerformanceCriterion> givenCriteria, boolean skipUndefinedLabels, boolean useExampleWeights) throws OperatorException {
        Attribute weightAttribute;
        if (testSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)evaluator, 105, new Object[0]);
        }
        if (testSet.getAttributes().getPredictedLabel() == null) {
            throw new UserError((Operator)evaluator, 107, new Object[0]);
        }
        if (useExampleWeights && (weightAttribute = testSet.getAttributes().getWeight()) != null) {
            if (!weightAttribute.isNumerical()) {
                throw new UserError((Operator)evaluator, 120, weightAttribute.getName(), Ontology.VALUE_TYPE_NAMES[weightAttribute.getValueType()], Ontology.VALUE_TYPE_NAMES[2]);
            }
            testSet.recalculateAttributeStatistics(weightAttribute);
            double minimum = testSet.getStatistics(weightAttribute, "minimum");
            if (Double.isNaN(minimum) || minimum < 0.0) {
                throw new UserError((Operator)evaluator, 138, weightAttribute.getName(), "positive values", "negative for some examples");
            }
        }
        int pc = 0;
        while (pc < performanceCriteria.size()) {
            PerformanceCriterion c = performanceCriteria.getCriterion(pc);
            if (!givenCriteria.contains(c)) {
                double[] weights;
                Attribute label;
                if (!(c instanceof MeasuredPerformance)) {
                    throw new UserError((Operator)evaluator, 903, new Object[0]);
                }
                ((MeasuredPerformance)c).startCounting(testSet, useExampleWeights);
                if (c instanceof ClassWeightedPerformance && evaluator != null && (label = testSet.getAttributes().getLabel()).isNominal() && (weights = evaluator.getClassWeights(label)) != null) {
                    ((ClassWeightedPerformance)((Object)c)).setWeights(weights);
                }
            }
            ++pc;
        }
        for (Example example : testSet) {
            if (skipUndefinedLabels && (Double.isNaN(example.getLabel()) || Double.isNaN(example.getPredictedLabel()))) continue;
            int pc2 = 0;
            while (pc2 < performanceCriteria.size()) {
                PerformanceCriterion criterion = performanceCriteria.getCriterion(pc2);
                if (!givenCriteria.contains(criterion) && criterion instanceof MeasuredPerformance) {
                    ((MeasuredPerformance)criterion).countExample(example);
                }
                ++pc2;
            }
            if (evaluator == null) continue;
            evaluator.checkForStop();
        }
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    private String[] getAllCriteriaNames() {
        List<PerformanceCriterion> criteria = this.getCriteria();
        String[] result = new String[criteria.size()];
        int counter = 0;
        for (PerformanceCriterion criterion : criteria) {
            result[counter++] = criterion.getName();
        }
        return result;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        if (this.showCriteriaParameter()) {
            String[] criteriaNames = this.getAllCriteriaNames();
            if (criteriaNames.length > 0) {
                String[] allCriteriaNames = new String[criteriaNames.length + 1];
                allCriteriaNames[0] = "first";
                System.arraycopy(criteriaNames, 0, allCriteriaNames, 1, criteriaNames.length);
                ParameterTypeStringCategory type = new ParameterTypeStringCategory(PARAMETER_MAIN_CRITERION, "The criterion used for comparing performance vectors.", allCriteriaNames, allCriteriaNames[0]);
                type.setExpert(false);
                types.add(type);
            }
            List<PerformanceCriterion> criteria = this.getCriteria();
            for (PerformanceCriterion criterion : criteria) {
                ParameterTypeBoolean type = new ParameterTypeBoolean(criterion.getName(), criterion.getDescription(), false);
                type.setExpert(false);
                types.add(type);
            }
        }
        if (this.showSkipNaNLabelsParameter()) {
            types.add(new ParameterTypeBoolean(PARAMETER_SKIP_UNDEFINED_LABELS, "If set to true, examples with undefined labels are skipped.", true));
        }
        if (this.showComparatorParameter()) {
            types.add(new ParameterTypeString(PARAMETER_COMPARATOR_CLASS, "Fully qualified classname of the PerformanceComparator implementation.", true));
        }
        types.add(new ParameterTypeBoolean(PARAMETER_USE_EXAMPLE_WEIGHTS, "Indicated if example weights should be used for performance calculations if possible.", true));
        return types;
    }
}

