/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SimpleChainInnerOperatorCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandling
extends OperatorChain {
    private boolean withoutError = true;

    public ExceptionHandling(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.withoutError = true;
        try {
            return super.apply();
        }
        catch (Exception e) {
            this.logWarning("Error occurred and will be neglected by " + this.getName() + ": " + e.getMessage());
            this.withoutError = false;
            return new IOObject[0];
        }
    }

    @Override
    public boolean getAddOnlyAdditionalOutput() {
        return this.withoutError;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        if (this.getNumberOfOperators() > 0) {
            return this.getOperator(this.getNumberOfOperators() - 1).getOutputClasses();
        }
        return new Class[0];
    }
}

