/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.weka;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.weka.WekaAssociator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.WekaTools;
import java.util.LinkedList;
import java.util.List;
import weka.associations.Associator;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericWekaAssociationLearner
extends Operator
implements TechnicalInformationHandler {
    public static final String[] WEKA_ASSOCIATORS = WekaTools.getWekaClasses(Associator.class);
    private List<ParameterType> wekaParameters = new LinkedList<ParameterType>();

    public GenericWekaAssociationLearner(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Associator associator = this.getWekaAssociator(this.getOperatorClassName(), WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        this.log("Converting to Weka instances.");
        Instances instances = WekaTools.toWekaInstances(exampleSet, "MiningInstances", 3);
        try {
            this.log("Building Weka associator.");
            associator.buildAssociations(instances);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, this.getOperatorClassName(), e);
        }
        return new IOObject[]{new WekaAssociator(this.getOperatorClassName(), associator)};
    }

    private Associator getWekaAssociator(String prefixName, String[] parameters) throws OperatorException {
        String actualName = prefixName.substring("W-".length());
        String associatorName = null;
        int i = 0;
        while (i < WEKA_ASSOCIATORS.length) {
            if (WEKA_ASSOCIATORS[i].endsWith(actualName)) {
                associatorName = WEKA_ASSOCIATORS[i];
                break;
            }
            ++i;
        }
        Associator associator = null;
        try {
            Class<?> clazz = Class.forName(associatorName);
            associator = (Associator)clazz.newInstance();
            if (associator instanceof OptionHandler) {
                OptionHandler optionHandler = (OptionHandler)associator;
                optionHandler.setOptions(parameters);
            }
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, associatorName, e);
        }
        return associator;
    }

    public TechnicalInformation getTechnicalInformation() {
        try {
            Associator associator = this.getWekaAssociator(this.getOperatorClassName(), null);
            if (associator instanceof TechnicalInformationHandler) {
                return ((TechnicalInformationHandler)associator).getTechnicalInformation();
            }
            return null;
        }
        catch (OperatorException e) {
            return null;
        }
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{WekaAssociator.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        Associator associator = null;
        try {
            associator = this.getWekaAssociator(this.getOperatorClassName(), null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka associator " + this.getOperatorClassName());
        }
        this.wekaParameters = new LinkedList<ParameterType>();
        if (associator != null && associator instanceof OptionHandler) {
            WekaTools.addParameterTypes((OptionHandler)associator, types, this.wekaParameters, false, null);
        }
        return types;
    }
}

