/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.mathplot;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.mathplot.JMathPlotter3D;
import com.rapidminer.tools.math.MathFunctions;
import java.awt.Color;
import java.util.Iterator;
import org.math.plot.Plot3DPanel;

public class ScatterPlot3DColor
extends JMathPlotter3D {
    private static final long serialVersionUID = 6967871061963724679L;

    public ScatterPlot3DColor() {
    }

    public ScatterPlot3DColor(DataTable dataTable) {
        super(dataTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        int colorColumn = -1;
        if (this.getAxis(0) != -1 && this.getAxis(1) != -1 && this.getAxis(2) != -1) {
            this.getPlotPanel().removeAllPlots();
            int currentVariable = 0;
            while (currentVariable < this.countColumns()) {
                if (this.getPlotColumn(currentVariable)) {
                    DataTable table;
                    double min = Double.POSITIVE_INFINITY;
                    double max = Double.NEGATIVE_INFINITY;
                    colorColumn = currentVariable;
                    DataTable dataTable = table = this.getDataTable();
                    synchronized (dataTable) {
                        for (DataTableRow row : table) {
                            double value = row.getValue(currentVariable);
                            min = MathFunctions.robustMin(min, value);
                            max = MathFunctions.robustMax(max, value);
                        }
                        Iterator<DataTableRow> iterator = this.getDataTable().iterator();
                        while (iterator.hasNext()) {
                            double[][] data = new double[1][3];
                            DataTableRow row = iterator.next();
                            data[0][0] = row.getValue(this.getAxis(0));
                            data[0][1] = row.getValue(this.getAxis(1));
                            data[0][2] = row.getValue(this.getAxis(2));
                            double colorValue = this.getColorProvider().getPointColorValue(table, row, currentVariable, min, max);
                            if (Double.isNaN(colorValue)) {
                                colorValue = 0.0;
                            }
                            Color color = this.getColorProvider().getPointColor(colorValue);
                            if (Double.isNaN(data[0][0]) || Double.isNaN(data[0][1]) || Double.isNaN(data[0][2])) continue;
                            ((Plot3DPanel)this.getPlotPanel()).addScatterPlot(this.getDataTable().getColumnName(currentVariable), color, data);
                        }
                    }
                }
                ++currentVariable;
            }
        }
        if (colorColumn != -1) {
            this.getLegendComponent().setLegendColumn(this.getDataTable(), colorColumn);
        }
    }

    public boolean hasLegend() {
        return false;
    }

    public boolean hasRapidMinerValueLegend() {
        return true;
    }

    public int getNumberOfAxes() {
        return 3;
    }

    public String getAxisName(int index) {
        switch (index) {
            case 0: {
                return "x-Axis";
            }
            case 1: {
                return "y-Axis";
            }
            case 2: {
                return "z-Axis";
            }
        }
        return "empty";
    }

    public String getPlotName() {
        return "Color";
    }
}

