/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableListener;
import com.rapidminer.gui.plotter.AndrewsCurves;
import com.rapidminer.gui.plotter.BoundDiagram;
import com.rapidminer.gui.plotter.ColorQuartileMatrixPlotter;
import com.rapidminer.gui.plotter.ColorQuartilePlotter;
import com.rapidminer.gui.plotter.CoordinatesHandler;
import com.rapidminer.gui.plotter.DensityPlotter;
import com.rapidminer.gui.plotter.GridVizPlotter;
import com.rapidminer.gui.plotter.HintonDiagram;
import com.rapidminer.gui.plotter.Plotter;
import com.rapidminer.gui.plotter.PlotterMouseHandler;
import com.rapidminer.gui.plotter.QuartilePlotter;
import com.rapidminer.gui.plotter.RadVizPlotter;
import com.rapidminer.gui.plotter.ScatterMatrixPlotter;
import com.rapidminer.gui.plotter.ScatterPlotter;
import com.rapidminer.gui.plotter.SurveyPlotter;
import com.rapidminer.gui.plotter.charts.BarChartPlotter;
import com.rapidminer.gui.plotter.charts.BlockChartPlotter;
import com.rapidminer.gui.plotter.charts.BubbleChartPlotter;
import com.rapidminer.gui.plotter.charts.DeviationChartPlotter;
import com.rapidminer.gui.plotter.charts.DistributionPlotter;
import com.rapidminer.gui.plotter.charts.HistogramChart;
import com.rapidminer.gui.plotter.charts.HistogramColorChart;
import com.rapidminer.gui.plotter.charts.MultipleScatterPlotter;
import com.rapidminer.gui.plotter.charts.MultipleSeriesChartPlotter;
import com.rapidminer.gui.plotter.charts.ParallelPlotter2;
import com.rapidminer.gui.plotter.charts.ParetoChartPlotter;
import com.rapidminer.gui.plotter.charts.PieChart2DPlotter;
import com.rapidminer.gui.plotter.charts.PieChart3DPlotter;
import com.rapidminer.gui.plotter.charts.RapidBarPainter;
import com.rapidminer.gui.plotter.charts.RapidXYBarPainter;
import com.rapidminer.gui.plotter.charts.RingChartPlotter;
import com.rapidminer.gui.plotter.charts.ScatterPlotter2;
import com.rapidminer.gui.plotter.charts.SeriesChartPlotter;
import com.rapidminer.gui.plotter.conditions.PlotterCondition;
import com.rapidminer.gui.plotter.mathplot.BoxPlot2D;
import com.rapidminer.gui.plotter.mathplot.BoxPlot3D;
import com.rapidminer.gui.plotter.mathplot.ScatterPlot3D;
import com.rapidminer.gui.plotter.mathplot.ScatterPlot3DColor;
import com.rapidminer.gui.plotter.mathplot.SticksPlot2D;
import com.rapidminer.gui.plotter.mathplot.SticksPlot3D;
import com.rapidminer.gui.plotter.mathplot.SurfacePlot3D;
import com.rapidminer.gui.plotter.som.SOMPlotter;
import com.rapidminer.gui.tools.ExtendedJComboBox;
import com.rapidminer.gui.tools.ExtendedJList;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedListModel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.visualization.SOMModelPlotter;
import com.rapidminer.report.Renderable;
import com.rapidminer.tools.LogService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.freehep.util.export.ExportDialog;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotterPanel
extends JPanel
implements ItemListener,
Renderable,
CoordinatesHandler,
DataTableListener {
    private static final long serialVersionUID = -8724351470349745191L;
    public static final int DEFAULT_MAX_NUMBER_OF_DATA_POINTS = 5000;
    public static final LinkedHashMap<String, Class<? extends Plotter>> COMPLETE_PLOTTER_SELECTION = new LinkedHashMap();
    public static final LinkedHashMap<String, Class<? extends Plotter>> WEIGHT_PLOTTER_SELECTION = new LinkedHashMap();
    public static final LinkedHashMap<String, Class<? extends Plotter>> DATA_SET_PLOTTER_SELECTION = new LinkedHashMap();
    public static final LinkedHashMap<String, Class<? extends Plotter>> MODEL_PLOTTER_SELECTION = new LinkedHashMap();
    public static final LinkedHashMap<String, Class<? extends Plotter>> COLOR_HISTOGRAM_PLOTTER_SELECTION = new LinkedHashMap();
    private Plotter plotter = null;
    private transient DataTable dataTable;
    private JLabel coordinatesLabel = new JLabel("                      ");
    private String selectedPlotter = null;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JComboBox plotterCombo = new JComboBox();
    private JList plotList = null;
    private List<JComboBox> axisCombos = new LinkedList<JComboBox>();
    private JComboBox plotCombo = null;
    private LinkedHashMap<String, Class<? extends Plotter>> availablePlotters = new LinkedHashMap();

    static {
        BarRenderer.setDefaultBarPainter((BarPainter)new RapidBarPainter());
        XYBarRenderer.setDefaultBarPainter((XYBarPainter)new RapidXYBarPainter());
        COMPLETE_PLOTTER_SELECTION.put("Scatter", ScatterPlotter2.class);
        COMPLETE_PLOTTER_SELECTION.put("Scatter Multiple", MultipleScatterPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Scatter Matrix", ScatterMatrixPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Scatter 3D", ScatterPlot3D.class);
        COMPLETE_PLOTTER_SELECTION.put("Scatter 3D Color", ScatterPlot3DColor.class);
        COMPLETE_PLOTTER_SELECTION.put("Bubble", BubbleChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Parallel", ParallelPlotter2.class);
        COMPLETE_PLOTTER_SELECTION.put("Deviation", DeviationChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Series", SeriesChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Series Multiple", MultipleSeriesChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Survey", SurveyPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("SOM", SOMPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Block", BlockChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Density", DensityPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Pie", PieChart2DPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Pie 3D", PieChart3DPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Ring", RingChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Bars", BarChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Pareto", ParetoChartPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Andrews Curves", AndrewsCurves.class);
        COMPLETE_PLOTTER_SELECTION.put("Distribution", DistributionPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Histogram", HistogramChart.class);
        COMPLETE_PLOTTER_SELECTION.put("Histogram Color", HistogramColorChart.class);
        COMPLETE_PLOTTER_SELECTION.put("Quartile", QuartilePlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Quartile Color", ColorQuartilePlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Quartile Color Matrix", ColorQuartileMatrixPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Sticks", SticksPlot2D.class);
        COMPLETE_PLOTTER_SELECTION.put("Sticks 3D", SticksPlot3D.class);
        COMPLETE_PLOTTER_SELECTION.put("Box", BoxPlot2D.class);
        COMPLETE_PLOTTER_SELECTION.put("Box 3D", BoxPlot3D.class);
        COMPLETE_PLOTTER_SELECTION.put("RadViz", RadVizPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("GridViz", GridVizPlotter.class);
        COMPLETE_PLOTTER_SELECTION.put("Surface 3D", SurfacePlot3D.class);
        COMPLETE_PLOTTER_SELECTION.put("Hinton", HintonDiagram.class);
        COMPLETE_PLOTTER_SELECTION.put("Bound", BoundDiagram.class);
        WEIGHT_PLOTTER_SELECTION.put("Lines", ScatterPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put("Histogram", HistogramChart.class);
        WEIGHT_PLOTTER_SELECTION.put("Hinton", HintonDiagram.class);
        WEIGHT_PLOTTER_SELECTION.put("Bound", BoundDiagram.class);
        WEIGHT_PLOTTER_SELECTION.put("Pie", PieChart2DPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put("Pie 3D", PieChart3DPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put("Ring", RingChartPlotter.class);
        WEIGHT_PLOTTER_SELECTION.put("Bars", BarChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Scatter", ScatterPlotter2.class);
        DATA_SET_PLOTTER_SELECTION.put("Scatter Multiple", MultipleScatterPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Scatter Matrix", ScatterMatrixPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Scatter 3D", ScatterPlot3D.class);
        DATA_SET_PLOTTER_SELECTION.put("Scatter 3D Color", ScatterPlot3DColor.class);
        DATA_SET_PLOTTER_SELECTION.put("Bubble", BubbleChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Parallel", ParallelPlotter2.class);
        DATA_SET_PLOTTER_SELECTION.put("Deviation", DeviationChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Series", SeriesChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Series Multiple", MultipleSeriesChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Survey", SurveyPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("SOM", SOMPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Block", BlockChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Density", DensityPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Pie", PieChart2DPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Pie 3D", PieChart3DPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Ring", RingChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Bars", BarChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Pareto", ParetoChartPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Andrews Curves", AndrewsCurves.class);
        DATA_SET_PLOTTER_SELECTION.put("Distribution", DistributionPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Histogram", HistogramChart.class);
        DATA_SET_PLOTTER_SELECTION.put("Histogram Color", HistogramColorChart.class);
        DATA_SET_PLOTTER_SELECTION.put("Quartile", QuartilePlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Quartile Color", ColorQuartilePlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Quartile Color Matrix", ColorQuartileMatrixPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Sticks", SticksPlot2D.class);
        DATA_SET_PLOTTER_SELECTION.put("Sticks 3D", SticksPlot3D.class);
        DATA_SET_PLOTTER_SELECTION.put("Box", BoxPlot2D.class);
        DATA_SET_PLOTTER_SELECTION.put("Box 3D", BoxPlot3D.class);
        DATA_SET_PLOTTER_SELECTION.put("RadViz", RadVizPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("GridViz", GridVizPlotter.class);
        DATA_SET_PLOTTER_SELECTION.put("Surface 3D", SurfacePlot3D.class);
        MODEL_PLOTTER_SELECTION.put("SOM", SOMModelPlotter.class);
        COLOR_HISTOGRAM_PLOTTER_SELECTION.put("Histogram Color", HistogramColorChart.class);
    }

    public PlotterPanel(DataTable dataTable) {
        this(dataTable, DATA_SET_PLOTTER_SELECTION);
    }

    public PlotterPanel(DataTable dataTable, LinkedHashMap<String, Class<? extends Plotter>> availablePlotters) {
        super(new BorderLayout());
        this.availablePlotters = availablePlotters;
        if (this.availablePlotters == null || this.availablePlotters.size() == 0) {
            throw new IllegalArgumentException("The list of available plotters must not be null or empty!");
        }
        Iterator<String> i = availablePlotters.keySet().iterator();
        this.selectedPlotter = i.next();
        ExtendedJScrollPane plotterScrollPane = new ExtendedJScrollPane(this.mainPanel);
        this.add((Component)plotterScrollPane, "Center");
        this.setDataTable(dataTable);
    }

    public void setSelectedPlotter(String name) {
        this.selectedPlotter = name;
        this.update(false);
    }

    public Plotter getSelectedPlotter() {
        return this.plotter;
    }

    public void setAxis(int index, int dimension) {
        Plotter plotter = this.getSelectedPlotter();
        if (plotter != null && index >= 0 && index < this.axisCombos.size() && dimension >= 0 && dimension < this.axisCombos.get(index).getModel().getSize()) {
            this.axisCombos.get(index).setSelectedIndex(dimension + 1);
        }
    }

    public void setPlotColumn(int index, boolean plot) {
        Plotter plotter = this.getSelectedPlotter();
        if (plotter != null) {
            switch (plotter.getValuePlotSelectionType()) {
                case 1: {
                    if (this.plotList == null || index < 0 || index >= this.plotList.getModel().getSize() || !plot) break;
                    this.plotList.setSelectedIndex(index);
                    break;
                }
                case 0: {
                    if (this.plotCombo == null || index < 0 || index >= this.plotCombo.getModel().getSize() || !plot) break;
                    this.plotCombo.setSelectedIndex(index + 1);
                    break;
                }
            }
        }
    }

    @Override
    public void dataTableUpdated(DataTable source) {
        int maxRowNumber = 5000;
        String maxRowNumberString = System.getProperty("rapidminer.gui.plotter.rows.maximum");
        if (maxRowNumberString != null && maxRowNumberString.trim().length() > 0) {
            try {
                int newMaxRows;
                maxRowNumber = newMaxRows = Integer.parseInt(maxRowNumberString);
            }
            catch (NumberFormatException e) {
                LogService.getGlobal().log("Plotter: cannot read maximum number of plotter points (was '" + maxRowNumberString + "').", 5);
            }
        }
        if (source.getNumberOfRows() > maxRowNumber) {
            this.dataTable = source.sample(maxRowNumber);
            LogService.getGlobal().log("Cannot plot all data points, using only a sample of " + maxRowNumber + " rows. You can increase the number of values in the properties dialog from the tools menu, the property name is '" + "rapidminer.gui.plotter.rows.maximum" + "'", 5);
        } else {
            this.dataTable = source;
        }
        if (this.plotter != null) {
            this.plotter.setDataTable(this.dataTable);
        }
    }

    public void setDataTable(DataTable dataTable) {
        this.dataTableUpdated(dataTable);
        this.dataTable.addDataTableListener(this);
        this.update(true);
    }

    private void update(boolean fillPlotterList) {
        int index;
        int j;
        int[] axis = null;
        LinkedList<Integer> valuesList = new LinkedList<Integer>();
        if (this.plotter != null) {
            axis = new int[this.plotter.getNumberOfAxes()];
            int i = 0;
            while (i < axis.length) {
                axis[i] = this.plotter.getAxis(i);
                ++i;
            }
            i = 0;
            while (i < this.dataTable.getNumberOfColumns()) {
                if (this.plotter.getPlotColumn(i)) {
                    valuesList.add(i);
                }
                ++i;
            }
        }
        int[] selectedIndices = new int[valuesList.size()];
        int k = 0;
        Iterator v = valuesList.iterator();
        while (v.hasNext()) {
            selectedIndices[k++] = (Integer)v.next();
        }
        try {
            Class<? extends Plotter> plotterClass = this.availablePlotters.get(this.selectedPlotter);
            if (plotterClass != null) {
                this.plotter = this.availablePlotters.get(this.selectedPlotter).newInstance();
                this.plotter.setDataTable(this.dataTable);
            }
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage("Cannot instantiate plotter '" + this.selectedPlotter + "':", e);
            return;
        }
        this.mainPanel.removeAll();
        PlotterMouseHandler mouseHandler = new PlotterMouseHandler(this.plotter, this);
        this.plotter.addMouseMotionListener(mouseHandler);
        this.plotter.addMouseListener(mouseHandler);
        JComponent plotterComponent = this.plotter.getPlotter();
        this.mainPanel.add((Component)plotterComponent, "Center");
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel axesSelectionPanel = new JPanel(gridBag);
        JLabel label = null;
        String toolTip = null;
        if (this.availablePlotters.size() > 1) {
            toolTip = "The plotter which should be used for displaying data.";
            label = new JLabel("Plotter");
            label.setToolTipText(toolTip);
            gridBag.setConstraints(label, c);
            axesSelectionPanel.add(label);
            if (fillPlotterList) {
                this.updatePlotterCombo();
            }
            gridBag.setConstraints(this.plotterCombo, c);
            axesSelectionPanel.add(this.plotterCombo);
        }
        this.axisCombos.clear();
        int i = 0;
        while (i < this.plotter.getNumberOfAxes()) {
            toolTip = "Select a column for " + this.plotter.getAxisName(i);
            label = new JLabel(this.plotter.getAxisName(i));
            label.setToolTipText(toolTip);
            gridBag.setConstraints(label, c);
            axesSelectionPanel.add(label);
            final ExtendedJComboBox axisCombo = new ExtendedJComboBox(200);
            axisCombo.setToolTipText(toolTip);
            axisCombo.addItem("None");
            j = 0;
            while (j < this.dataTable.getNumberOfColumns()) {
                axisCombo.addItem(this.dataTable.getColumnName(j));
                ++j;
            }
            index = i;
            axisCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    PlotterPanel.this.plotter.setAxis(index, axisCombo.getSelectedIndex() - 1);
                }
            });
            if (axis != null && axis.length > i) {
                axisCombo.setSelectedIndex(Math.max(0, axis[i] + 1));
            }
            gridBag.setConstraints(axisCombo, c);
            axesSelectionPanel.add(axisCombo);
            this.axisCombos.add(axisCombo);
            if (this.plotter.isSupportingLogScale(i)) {
                final JCheckBox logScaleBox = new JCheckBox("Log Scale", false);
                logScaleBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PlotterPanel.this.plotter.setLogScale(index, logScaleBox.isSelected());
                    }
                });
                gridBag.setConstraints(logScaleBox, c);
                axesSelectionPanel.add(logScaleBox);
            }
            ++i;
        }
        this.plotCombo = null;
        this.plotList = null;
        if (this.plotter.getValuePlotSelectionType() != -1) {
            JLabel plotLabel;
            if (this.plotter.getPlotName() == null) {
                plotLabel = new JLabel("Plots");
                toolTip = "Select the column which should be plotted.";
            } else {
                plotLabel = new JLabel(this.plotter.getPlotName());
                toolTip = "Select a column for " + this.plotter.getPlotName();
            }
            plotLabel.setToolTipText(toolTip);
            gridBag.setConstraints(plotLabel, c);
            axesSelectionPanel.add(plotLabel);
        }
        switch (this.plotter.getValuePlotSelectionType()) {
            case 1: {
                ExtendedListModel model = new ExtendedListModel();
                String[] stringArray = this.dataTable.getColumnNames();
                int n = stringArray.length;
                index = 0;
                while (index < n) {
                    String name = stringArray[index];
                    model.addElement(name, "Select column '" + name + "' for plotting.");
                    ++index;
                }
                this.plotList = new ExtendedJList(model, 200);
                this.plotList.setToolTipText(toolTip);
                this.plotList.setBorder(BorderFactory.createLoweredBevelBorder());
                this.plotList.setCellRenderer(new LineStyleCellRenderer(this.plotter));
                this.plotList.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent e) {
                        int i = 0;
                        while (i < PlotterPanel.this.plotList.getModel().getSize()) {
                            PlotterPanel.this.plotter.setPlotColumn(i, PlotterPanel.this.plotList.isSelectedIndex(i));
                            ++i;
                        }
                    }
                });
                this.plotList.setSelectionMode(2);
                this.plotList.setSelectedIndices(selectedIndices);
                ExtendedJScrollPane listScrollPane = new ExtendedJScrollPane(this.plotList);
                listScrollPane.setHorizontalScrollBarPolicy(30);
                c.weighty = 1.0;
                c.weightx = 0.0;
                gridBag.setConstraints(listScrollPane, c);
                axesSelectionPanel.add(listScrollPane);
                c.weighty = 0.0;
                c.weightx = 1.0;
                break;
            }
            case 0: {
                this.plotCombo = new ExtendedJComboBox(200);
                this.plotCombo.setToolTipText(toolTip);
                this.plotCombo.addItem("None");
                j = 0;
                while (j < this.dataTable.getNumberOfColumns()) {
                    this.plotCombo.addItem(this.dataTable.getColumnName(j));
                    ++j;
                }
                this.plotCombo.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        PlotterPanel.this.plotter.setPlotColumn(PlotterPanel.this.plotCombo.getSelectedIndex() - 1, true);
                    }
                });
                if (selectedIndices.length > 0) {
                    this.plotCombo.setSelectedIndex(selectedIndices[0] + 1);
                }
                gridBag.setConstraints(this.plotCombo, c);
                axesSelectionPanel.add(this.plotCombo);
                break;
            }
        }
        if (this.plotter.isSupportingLogScaleForPlotColumns()) {
            final JCheckBox logScaleBox = new JCheckBox("Log Scale", false);
            logScaleBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotterPanel.this.plotter.setLogScaleForPlotColumns(logScaleBox.isSelected());
                }
            });
            gridBag.setConstraints(logScaleBox, c);
            axesSelectionPanel.add(logScaleBox);
        }
        if (this.plotter.isSupportingSorting()) {
            final JCheckBox sortingBox = new JCheckBox("Sorting", false);
            sortingBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotterPanel.this.plotter.setSorting(sortingBox.isSelected());
                }
            });
            gridBag.setConstraints(sortingBox, c);
            axesSelectionPanel.add(sortingBox);
        }
        if (this.plotter.isSupportingAbsoluteValues()) {
            final JCheckBox absoluteBox = new JCheckBox("Absolute Values", false);
            absoluteBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotterPanel.this.plotter.setAbsolute(absoluteBox.isSelected());
                }
            });
            gridBag.setConstraints(absoluteBox, c);
            axesSelectionPanel.add(absoluteBox);
        }
        if (this.plotter.canHandleZooming()) {
            label = new JLabel("Zooming");
            toolTip = "Set a new zooming factor.";
            label.setToolTipText(toolTip);
            gridBag.setConstraints(label, c);
            axesSelectionPanel.add(label);
            final JSlider zoomingSlider = new JSlider(1, 100, this.plotter.getInitialZoomFactor());
            zoomingSlider.setToolTipText(toolTip);
            gridBag.setConstraints(zoomingSlider, c);
            axesSelectionPanel.add(zoomingSlider);
            zoomingSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    PlotterPanel.this.plotter.setZooming(zoomingSlider.getValue());
                }
            });
        }
        if (this.plotter.canHandleJitter()) {
            label = new JLabel("Jitter");
            toolTip = "Select the amount of jittering (small perturbation of data points).";
            label.setToolTipText(toolTip);
            gridBag.setConstraints(label, c);
            axesSelectionPanel.add(label);
            final JSlider jitterSlider = new JSlider(0, 100, 0);
            jitterSlider.setToolTipText(toolTip);
            gridBag.setConstraints(jitterSlider, c);
            axesSelectionPanel.add(jitterSlider);
            jitterSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (PlotterPanel.this.plotter.canHandleContinousJittering() || !jitterSlider.getValueIsAdjusting()) {
                        PlotterPanel.this.plotter.setJitter(jitterSlider.getValue());
                    }
                }
            });
        }
        if (this.plotter.hasOptionsDialog()) {
            toolTip = "Opens a dialog with further options for this plotter.";
            JButton optionsButton = new JButton("Options");
            optionsButton.setToolTipText(toolTip);
            gridBag.setConstraints(optionsButton, c);
            axesSelectionPanel.add(optionsButton);
            optionsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotterPanel.this.plotter.showOptionsDialog();
                }
            });
        }
        int componentCounter = 0;
        while (this.plotter.getOptionsComponent(componentCounter) != null) {
            JComponent options = this.plotter.getOptionsComponent(componentCounter);
            gridBag.setConstraints(options, c);
            axesSelectionPanel.add(options);
            ++componentCounter;
        }
        if (!this.plotter.hasSaveImageButton()) {
            toolTip = "Saves an image of the current plot.";
            JButton imageButton = new JButton("Save Image...");
            imageButton.setToolTipText(toolTip);
            imageButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComponent tosave = PlotterPanel.this.plotter.getPlotter();
                    ExportDialog exportDialog = new ExportDialog("RapidMiner");
                    exportDialog.showExportDialog(PlotterPanel.this.getPanel(), "Save Image...", (Component)tosave, "plot");
                }
            });
            gridBag.setConstraints(imageButton, c);
            axesSelectionPanel.add(imageButton);
        }
        if (this.plotter.isSaveable()) {
            toolTip = "Saves the data underlying this plot into a file.";
            JButton saveButton = new JButton("Save...");
            saveButton.setToolTipText(toolTip);
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PlotterPanel.this.plotter.save();
                }
            });
            gridBag.setConstraints(saveButton, c);
            axesSelectionPanel.add(saveButton);
        }
        if (this.plotter.isProvidingCoordinates()) {
            this.coordinatesLabel = new JLabel("                      ");
            toolTip = "The current coordinates of the mouese cursor with respect to the data dimensions.";
            this.coordinatesLabel.setToolTipText(toolTip);
            this.coordinatesLabel.setBorder(BorderFactory.createEtchedBorder());
            this.coordinatesLabel.setFont(new Font("Monospaced", 0, this.coordinatesLabel.getFont().getSize()));
            gridBag.setConstraints(this.coordinatesLabel, c);
            axesSelectionPanel.add(this.coordinatesLabel);
        }
        if (this.plotter.getValuePlotSelectionType() != 1) {
            c.weighty = 1.0;
            JPanel fillPanel = new JPanel();
            gridBag.setConstraints(fillPanel, c);
            axesSelectionPanel.add(fillPanel);
            c.weighty = 0.0;
        }
        axesSelectionPanel.setAlignmentX(0.0f);
        this.mainPanel.add((Component)axesSelectionPanel, "West");
        this.revalidate();
        this.repaint();
    }

    private Component getPanel() {
        return this;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setSelectedPlotter((String)this.plotterCombo.getSelectedItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlotterCombo() {
        JComboBox jComboBox = this.plotterCombo;
        synchronized (jComboBox) {
            this.plotterCombo.removeItemListener(this);
            this.plotterCombo.removeAllItems();
            for (String plotterName : this.availablePlotters.keySet()) {
                try {
                    Class<? extends Plotter> plotterClass = this.availablePlotters.get(plotterName);
                    if (plotterClass == null) continue;
                    Plotter plotter = plotterClass.newInstance();
                    PlotterCondition condition = plotter.getPlotterCondition();
                    if (condition.acceptDataTable(this.dataTable)) {
                        this.plotterCombo.addItem(plotterName);
                        continue;
                    }
                    LogService.getGlobal().log("Cannot use plotter '" + plotterName + "': " + condition.getRejectionReason(this.dataTable), 4);
                }
                catch (InstantiationException e) {
                    LogService.getGlobal().log("Plotter panel: cannot instantiate plotter '" + plotterName + "'. Skipping...", 5);
                }
                catch (IllegalAccessException e) {
                    LogService.getGlobal().log("Plotter panel: cannot acess plotter '" + plotterName + "'. Skipping...", 5);
                }
            }
            this.plotterCombo.setToolTipText("The plotter which should be used for displaying data.");
            this.plotterCombo.addItemListener(this);
        }
    }

    @Override
    public void prepareRendering() {
        this.plotter.prepareRendering();
    }

    @Override
    public void finishRendering() {
        this.plotter.finishRendering();
    }

    @Override
    public int getRenderHeight(int preferredHeight) {
        return this.plotter.getRenderHeight(preferredHeight);
    }

    @Override
    public int getRenderWidth(int preferredWidth) {
        return this.plotter.getRenderWidth(preferredWidth);
    }

    @Override
    public void render(Graphics graphics, int width, int height) {
        this.plotter.render(graphics, width, height);
    }

    @Override
    public void updateCoordinates(String coordinateInfo) {
        this.coordinatesLabel.setText(coordinateInfo);
    }

    public static class LineStyleCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -7039142638209143602L;
        Plotter plotter;

        public LineStyleCellRenderer(Plotter plotter) {
            this.plotter = plotter;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            Icon icon = this.plotter.getIcon(index);
            if (icon != null) {
                this.setIcon(icon);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

