/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.operatormenu;

import com.rapidminer.gui.operatormenu.NewOperatorMenu;
import com.rapidminer.gui.operatormenu.ReplaceOperatorMenu;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public abstract class OperatorMenu
extends JMenu {
    private static final long serialVersionUID = 2685621612717488446L;
    public static final OperatorMenu NEW_OPERATOR_MENU = new NewOperatorMenu();
    public static final OperatorMenu REPLACE_OPERATOR_MENU = new ReplaceOperatorMenu(false);
    public static final OperatorMenu REPLACE_OPERATORCHAIN_MENU = new ReplaceOperatorMenu(true);

    protected OperatorMenu(String name, boolean onlyChains) {
        super(name);
        this.addMenu(OperatorService.getGroups(), this, onlyChains);
    }

    public void addMenu(GroupTree group, JMenu menu, boolean onlyChains) {
        for (GroupTree subGroup : group.getSubGroups()) {
            JMenu subMenu = new JMenu(subGroup.getName());
            this.addMenu(subGroup, subMenu, onlyChains);
            if (subMenu.getItemCount() <= 0) continue;
            menu.add(subMenu);
        }
        for (final OperatorDescription description : group.getOperatorDescriptions()) {
            if (onlyChains && !OperatorChain.class.isAssignableFrom(description.getOperatorClass())) continue;
            JMenuItem item = null;
            ImageIcon icon = description.getIcon();
            item = icon == null ? new JMenuItem(description.getName()) : new JMenuItem(description.getName(), icon);
            String descriptionText = description.getLongDescriptionHTML();
            if (descriptionText == null) {
                descriptionText = description.getShortDescription();
            }
            StringBuffer toolTipText = new StringBuffer("<b>Description: </b>" + descriptionText);
            Operator operator = null;
            try {
                operator = description.createOperatorInstance();
            }
            catch (OperatorCreationException operatorCreationException) {
                // empty catch block
            }
            if (operator != null) {
                toolTipText.append(String.valueOf(Tools.getLineSeparator()) + "<b>Input:</b> " + SwingTools.getStringFromClassArray(operator.getInputClasses()));
                toolTipText.append(String.valueOf(Tools.getLineSeparator()) + "<b>Output:</b> " + SwingTools.getStringFromClassArray(operator.getOutputClasses()));
            }
            item.setToolTipText(SwingTools.transformToolTipText(toolTipText.toString()));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OperatorMenu.this.performAction(description);
                }
            });
            if (description.getDeprecationInfo() != null || operator != null && operator.getDeprecationInfo() != null) {
                item.setForeground(Color.LIGHT_GRAY);
            }
            menu.add(item);
        }
    }

    public abstract void performAction(OperatorDescription var1);
}

