/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AbstractDataRowReader;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.RapidMinerLineReader;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.att.AttributeDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDataRowReader
extends AbstractDataRowReader {
    private static final int FILE_NR = 0;
    private static final int COLUMN_NR = 1;
    private BufferedReader[] fileReader;
    private Attribute[] attributes;
    private boolean eof;
    private boolean lineRead;
    private double sampleRatio = 1.0;
    private int maxNumber = -1;
    private int linesRead = 0;
    private String[][] currentData;
    private int[] expectedNumberOfColumns;
    private RapidMinerLineReader rapidMinerLineReader;
    private RandomGenerator random;
    private int[][] dataSourceIndex;

    public FileDataRowReader(DataRowFactory factory, List<AttributeDataSource> attributeDataSources, double sampleRatio, int sampleSize, String separatorsRegExpr, char[] commentChars, boolean useQuotes, char quoteChar, char escapeChar, boolean trimLines, boolean skipErrorLines, Charset encoding, RandomGenerator random) throws IOException {
        super(factory);
        this.sampleRatio = sampleRatio;
        this.maxNumber = sampleSize;
        this.attributes = new Attribute[attributeDataSources.size()];
        this.dataSourceIndex = new int[attributeDataSources.size()][2];
        this.rapidMinerLineReader = new RapidMinerLineReader(separatorsRegExpr, commentChars, useQuotes, quoteChar, escapeChar, trimLines, skipErrorLines);
        this.random = random;
        this.initReader(factory, attributeDataSources, sampleSize, separatorsRegExpr, useQuotes, encoding);
    }

    private void initReader(DataRowFactory factory, List<AttributeDataSource> attributeDataSources, int sampleSize, String separatorsRegExpr, boolean useQuotes, Charset encoding) throws IOException {
        LinkedList<BufferedReader> readerList = new LinkedList<BufferedReader>();
        HashMap<File, Integer> fileMap = new HashMap<File, Integer>();
        Iterator<AttributeDataSource> i = attributeDataSources.iterator();
        int attribute = 0;
        int greatestFileIndex = -1;
        ArrayList<AtomicInteger> columnCounters = new ArrayList<AtomicInteger>();
        while (i.hasNext()) {
            AttributeDataSource ads = i.next();
            this.attributes[attribute] = ads.getAttribute();
            File file = ads.getFile();
            Integer fileIndex = (Integer)fileMap.get(file);
            if (fileIndex == null) {
                fileIndex = ++greatestFileIndex;
                fileMap.put(file, fileIndex);
                readerList.add(Tools.getReader(file, encoding));
                columnCounters.add(new AtomicInteger(1));
            } else {
                AtomicInteger counter = (AtomicInteger)columnCounters.get(fileIndex);
                counter.incrementAndGet();
            }
            this.dataSourceIndex[attribute][0] = fileIndex;
            this.dataSourceIndex[attribute][1] = ads.getColumn();
            ++attribute;
        }
        this.fileReader = new BufferedReader[readerList.size()];
        readerList.toArray(this.fileReader);
        this.currentData = new String[this.fileReader.length][];
        this.expectedNumberOfColumns = new int[columnCounters.size()];
        Iterator j = columnCounters.iterator();
        int k = 0;
        while (j.hasNext()) {
            this.expectedNumberOfColumns[k++] = ((AtomicInteger)j.next()).intValue();
        }
    }

    public void skipLine() {
        try {
            this.readLine();
        }
        catch (Exception e) {
            LogService.getGlobal().log("Problem during skipping of line: " + e.getMessage(), 5);
        }
    }

    private boolean readLine() throws IOException {
        int i;
        boolean eofReached = false;
        boolean ok = false;
        while (!ok) {
            i = 0;
            while (i < this.fileReader.length) {
                this.currentData[i] = this.rapidMinerLineReader.readLine(this.fileReader[i], this.expectedNumberOfColumns[i]);
                if (this.currentData[i] == null) {
                    eofReached = true;
                    break;
                }
                ++i;
            }
            if (!eofReached && this.maxNumber == -1 && this.sampleRatio != 1.0 && !(this.random.nextDouble() < this.sampleRatio)) continue;
            ok = true;
        }
        if (eofReached) {
            i = 0;
            while (i < this.fileReader.length) {
                this.fileReader[i].close();
                ++i;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.maxNumber > -1 && this.linesRead >= this.maxNumber) {
            return false;
        }
        if (this.lineRead) {
            return !this.eof;
        }
        try {
            this.eof = !this.readLine();
        }
        catch (IOException e) {
            LogService.getGlobal().log(e.getMessage(), 6);
            return false;
        }
        this.lineRead = true;
        return !this.eof;
    }

    @Override
    public DataRow next() {
        if (this.eof) {
            return null;
        }
        if (!this.lineRead && !this.hasNext()) {
            return null;
        }
        String[] data = new String[this.attributes.length];
        int i = 0;
        while (i < this.attributes.length) {
            data[i] = this.dataSourceIndex[i][1] == -1 ? null : this.currentData[this.dataSourceIndex[i][0]][this.dataSourceIndex[i][1]];
            ++i;
        }
        DataRow dataRow = this.getFactory().create(data, this.attributes);
        ++this.linesRead;
        this.lineRead = false;
        return dataRow;
    }
}

