/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.table;

import com.rapidminer.example.table.DataRow;

public class ByteArrayDataRow
extends DataRow {
    private static final long serialVersionUID = -1428468572995891360L;
    private byte[] data;

    public ByteArrayDataRow(byte[] data) {
        this.data = data;
    }

    protected double get(int index, double defaultValue) {
        return this.data[index];
    }

    protected void set(int index, double value, double defaultValue) {
        this.data[index] = (byte)value;
    }

    protected void ensureNumberOfColumns(int numberOfColumns) {
        if (this.data.length >= numberOfColumns) {
            return;
        }
        byte[] newData = new byte[numberOfColumns];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }

    public void trim() {
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.data.length) {
            result.append(String.valueOf(i == 0 ? "" : ",") + this.data[i]);
            ++i;
        }
        return result.toString();
    }
}

