/*
 * Decompiled with CFR 0.152.
 */
package liblinear;

import liblinear.FeatureNode;
import liblinear.Function;
import liblinear.Problem;

class L2LrFunction
implements Function {
    private final double[] C;
    private final double[] z;
    private final double[] D;
    private final Problem prob;

    public L2LrFunction(Problem prob, double Cp, double Cn) {
        int l = prob.l;
        int[] y = prob.y;
        this.prob = prob;
        this.z = new double[l];
        this.D = new double[l];
        this.C = new double[l];
        int i = 0;
        while (i < l) {
            this.C[i] = y[i] == 1 ? Cp : Cn;
            ++i;
        }
    }

    private void Xv(double[] v, double[] Xv) {
        int i = 0;
        while (i < this.prob.l) {
            Xv[i] = 0.0;
            FeatureNode[] featureNodeArray = this.prob.x[i];
            int n = featureNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureNode s = featureNodeArray[n2];
                int n3 = i;
                Xv[n3] = Xv[n3] + v[s.index - 1] * s.value;
                ++n2;
            }
            ++i;
        }
    }

    private void XTv(double[] v, double[] XTv) {
        int l = this.prob.l;
        int n = this.prob.n;
        FeatureNode[][] x = this.prob.x;
        int i = 0;
        while (i < n) {
            XTv[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < l) {
            FeatureNode[] featureNodeArray = x[i];
            int n2 = featureNodeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FeatureNode s = featureNodeArray[n3];
                int n4 = s.index - 1;
                XTv[n4] = XTv[n4] + v[i] * s.value;
                ++n3;
            }
            ++i;
        }
    }

    public double fun(double[] w) {
        double f = 0.0;
        int[] y = this.prob.y;
        int l = this.prob.l;
        int n = this.prob.n;
        this.Xv(w, this.z);
        int i = 0;
        while (i < l) {
            double yz = (double)y[i] * this.z[i];
            f = yz >= 0.0 ? (f += this.C[i] * Math.log(1.0 + Math.exp(-yz))) : (f += this.C[i] * (-yz + Math.log(1.0 + Math.exp(yz))));
            ++i;
        }
        f *= 2.0;
        i = 0;
        while (i < n) {
            f += w[i] * w[i];
            ++i;
        }
        return f /= 2.0;
    }

    public void grad(double[] w, double[] g) {
        int[] y = this.prob.y;
        int l = this.prob.l;
        int n = this.prob.n;
        int i = 0;
        while (i < l) {
            this.z[i] = 1.0 / (1.0 + Math.exp((double)(-y[i]) * this.z[i]));
            this.D[i] = this.z[i] * (1.0 - this.z[i]);
            this.z[i] = this.C[i] * (this.z[i] - 1.0) * (double)y[i];
            ++i;
        }
        this.XTv(this.z, g);
        i = 0;
        while (i < n) {
            g[i] = w[i] + g[i];
            ++i;
        }
    }

    public void Hv(double[] s, double[] Hs) {
        int l = this.prob.l;
        int n = this.prob.n;
        double[] wa = new double[l];
        this.Xv(s, wa);
        int i = 0;
        while (i < l) {
            wa[i] = this.C[i] * this.D[i] * wa[i];
            ++i;
        }
        this.XTv(wa, Hs);
        i = 0;
        while (i < n) {
            Hs[i] = s[i] + Hs[i];
            ++i;
        }
    }

    public int get_nr_variable() {
        return this.prob.n;
    }
}

