/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CumulateSeries
extends AbstractSeriesProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_KEEP_ORIGINAL_ATTRIBUTE = "keep_original_attribute";

    public CumulateSeries(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (attribute.isNominal()) {
            this.logWarning("attribute is not numerical: change attribute not created.");
            return exampleSet;
        }
        Attribute cumulativeAttribute = AttributeFactory.createAttribute("cumulative(" + attribute.getName() + ")", 2);
        exampleSet.getExampleTable().addAttribute(cumulativeAttribute);
        exampleSet.getAttributes().addRegular(cumulativeAttribute);
        double sum = 0.0;
        for (Example example : exampleSet) {
            example.setValue(cumulativeAttribute, sum += example.getValue(attribute));
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(attribute);
        }
        exampleSet.recalculateAttributeStatistics(cumulativeAttribute);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the series attribute from which a cumulative series should be generated.", false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE, "Indicates whether the original attribute should be kept in the data set.", true);
        types.add(type);
        return types;
    }
}

