/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.AverageVector;
import com.rapidminer.tools.math.RunVector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AverageBuilder
extends Operator {
    public AverageBuilder(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        HashMap<Class, RunVector> classMap = new HashMap<Class, RunVector>();
        while (true) {
            AverageVector vector = null;
            try {
                vector = this.getInput(AverageVector.class);
            }
            catch (MissingIOObjectException e) {
                break;
            }
            this.addVector(vector, classMap);
        }
        Iterator i = classMap.keySet().iterator();
        LinkedList<AverageVector> averages = new LinkedList<AverageVector>();
        while (i.hasNext()) {
            RunVector runVector = (RunVector)classMap.get(i.next());
            averages.add(runVector.average());
        }
        IOObject[] result = new IOObject[averages.size()];
        averages.toArray(result);
        return result;
    }

    private void addVector(AverageVector vector, Map<Class, RunVector> classMap) {
        RunVector runVector = classMap.get(vector.getClass());
        if (runVector == null) {
            runVector = new RunVector();
            classMap.put(vector.getClass(), runVector);
        }
        runVector.addVector(vector);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{AverageVector.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{AverageVector.class};
    }
}

