/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.AbstractLearner;
import com.rapidminer.operator.learner.CapabilityCheck;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.operator.learner.igss.IGSSResult;
import com.rapidminer.operator.learner.igss.Result;
import com.rapidminer.operator.learner.igss.hypothesis.GSSModel;
import com.rapidminer.operator.learner.igss.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.igss.hypothesis.Rule;
import com.rapidminer.operator.learner.igss.utility.Accuracy;
import com.rapidminer.operator.learner.igss.utility.Binomial;
import com.rapidminer.operator.learner.igss.utility.Linear;
import com.rapidminer.operator.learner.igss.utility.Squared;
import com.rapidminer.operator.learner.igss.utility.Utility;
import com.rapidminer.operator.learner.igss.utility.WRAcc;
import com.rapidminer.operator.learner.meta.BayBoostBaseModelInfo;
import com.rapidminer.operator.learner.meta.BayBoostModel;
import com.rapidminer.operator.learner.meta.ContingencyMatrix;
import com.rapidminer.operator.learner.meta.WeightedPerformanceMeasures;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratingGSS
extends AbstractLearner {
    public static final String PARAMETER_EPSILON = "epsilon";
    public static final String PARAMETER_DELTA = "delta";
    public static final String PARAMETER_MIN_UTILITY_PRUNING = "min_utility_pruning";
    public static final String PARAMETER_MIN_UTILITY_USEFUL = "min_utility_useful";
    public static final String PARAMETER_STEPSIZE = "stepsize";
    public static final String PARAMETER_LARGE = "large";
    public static final String PARAMETER_MAX_COMPLEXITY = "max_complexity";
    public static final String PARAMETER_MIN_COMPLEXITY = "min_complexity";
    public static final String PARAMETER_ITERATIONS = "iterations";
    public static final String PARAMETER_USE_BINOMIAL = "use_binomial";
    public static final String PARAMETER_UTILITY_FUNCTION = "utility_function";
    public static final String PARAMETER_USE_KBS = "use_kbs";
    public static final String PARAMETER_REJECTION_SAMPLING = "rejection_sampling";
    public static final String PARAMETER_USEFUL_CRITERION = "useful_criterion";
    public static final String PARAMETER_EXAMPLE_FACTOR = "example_factor";
    public static final String PARAMETER_FORCE_ITERATIONS = "force_iterations";
    public static final String PARAMETER_GENERATE_ALL_HYPOTHESIS = "generate_all_hypothesis";
    public static final String PARAMETER_RESET_WEIGHTS = "reset_weights";
    public static final String[] CRITERION_TYPES = new String[]{"worst_utility", "utility", "best_utility", "example"};
    public static final int FIRST_TYPE_INDEX = 0;
    public static final int TYPE_WORST_UTILITY = 0;
    public static final int TYPE_UTILITY = 1;
    public static final int TYPE_BEST_UTILITY = 2;
    public static final int TYPE_EXAMPLE = 3;
    public static final int LAST_TYPE_INDEX = 3;
    private IGSSResult gssResult;
    private Attribute[] regularAttributes;
    private Attribute label;
    private Utility theUtility;
    private RandomGenerator random;
    private Hypothesis seed;
    private double totalWeight;
    private double totalPositiveWeight;
    private LinkedList<Hypothesis> bestList;
    private Result minBest;
    private Result maxRest;
    private int numberOfSolutions;
    private double currentDelta;
    private double epsilon;
    private int stepsize;
    private int maxComplexity;
    private int minComplexity;
    private double min_utility_pruning;
    private double min_utility_useful;
    private boolean useKBS;
    private boolean useBinomial;
    private int useful_criterion;
    private boolean forceIterations;
    private boolean resetWeights;
    private double exampleFactor;
    public int MIN_MODEL_NUMBER = 2;
    private boolean rejectionSampling;
    private int large;
    private int iterations;

    public IteratingGSS(OperatorDescription description) {
        super(description);
    }

    private void updateLists(LinkedList<Hypothesis> hypothesisList, int n, double totalExampleWeight, double totalPositiveWeight, double delta_h_m) {
        this.bestList = new LinkedList();
        LinkedList<Result> bestList = new LinkedList<Result>();
        LinkedList<Result> restList = new LinkedList<Result>();
        this.minBest = null;
        this.maxRest = null;
        for (Hypothesis hypo : hypothesisList) {
            double conf;
            double util;
            if (hypo.getCoveredWeight() > 0.0) {
                Result current;
                ListIterator<Result> listIterator;
                if (bestList.size() < n) {
                    if (bestList.isEmpty()) {
                        util = this.theUtility.utility(totalExampleWeight, totalPositiveWeight, hypo);
                        conf = this.theUtility.confidenceIntervall(totalExampleWeight, totalPositiveWeight, hypo, delta_h_m);
                        bestList.addLast(new Result(hypo, totalExampleWeight, totalPositiveWeight, util, conf));
                        continue;
                    }
                    util = this.theUtility.utility(totalExampleWeight, totalPositiveWeight, hypo);
                    conf = this.theUtility.confidenceIntervall(totalExampleWeight, totalPositiveWeight, hypo, delta_h_m);
                    listIterator = bestList.listIterator(0);
                    while (listIterator.hasNext()) {
                        current = (Result)listIterator.next();
                        if (!(util > current.getUtility())) continue;
                        listIterator.previous();
                        break;
                    }
                    listIterator.add(new Result(hypo, totalExampleWeight, totalPositiveWeight, util, conf));
                    continue;
                }
                util = this.theUtility.utility(totalExampleWeight, totalPositiveWeight, hypo);
                conf = this.theUtility.confidenceIntervall(totalExampleWeight, totalPositiveWeight, hypo, delta_h_m);
                if (util > ((Result)bestList.getLast()).getUtility()) {
                    listIterator = bestList.listIterator(0);
                    while (listIterator.hasNext()) {
                        current = (Result)listIterator.next();
                        if (!(util > current.getUtility())) continue;
                        listIterator.previous();
                        break;
                    }
                    listIterator.add(new Result(hypo, totalExampleWeight, totalPositiveWeight, util, conf));
                    restList.addLast((Result)bestList.removeLast());
                    continue;
                }
                restList.addLast(new Result(hypo, totalExampleWeight, totalPositiveWeight, util, conf));
                continue;
            }
            util = this.theUtility.utility(totalExampleWeight, totalPositiveWeight, hypo);
            conf = this.theUtility.confidenceIntervall(totalExampleWeight, totalPositiveWeight, hypo, delta_h_m);
            restList.addLast(new Result(hypo, totalExampleWeight, totalPositiveWeight, util, conf));
        }
        Result r2 = (Result)bestList.getLast();
        double minimum = r2.getUtility() - r2.getConfidence();
        this.minBest = r2;
        for (Result r2 : bestList) {
            double current = r2.getUtility() - r2.getConfidence();
            if (!(current < minimum)) continue;
            minimum = current;
            this.minBest = r2;
        }
        r2 = (Result)restList.getLast();
        double maximum = r2.getUtility() + r2.getConfidence();
        this.maxRest = r2;
        for (Result r2 : restList) {
            double current = r2.getUtility() + r2.getConfidence();
            if (!(current > maximum)) continue;
            maximum = current;
            this.maxRest = r2;
        }
        Iterator it = bestList.iterator();
        while (it.hasNext()) {
            this.bestList.addLast(((Result)it.next()).getHypothesis());
        }
    }

    public LinkedList<Result> gss(ExampleSet exampleSet, LinkedList<Hypothesis> hypothesisList, double delta, double epsilon) throws OperatorException {
        LinkedList<Hypothesis> delete = new LinkedList<Hypothesis>();
        LinkedList<Hypothesis> output = new LinkedList<Hypothesis>();
        LinkedList<Result> results = new LinkedList<Result>();
        this.bestList = new LinkedList();
        int n = this.numberOfSolutions;
        this.totalWeight = 0.0;
        this.totalPositiveWeight = 0.0;
        double delta_h = delta / (2.0 * (double)hypothesisList.size());
        double m = this.theUtility.calculateM(delta_h, epsilon);
        double delta_h_m = delta / (2.0 * (double)hypothesisList.size() * Math.ceil(m / (double)this.stepsize));
        double r = 0.0;
        double weightToAdd = 1.0;
        int nextUpdateValue = this.stepsize;
        do {
            int rand = this.random.nextInt(exampleSet.size());
            Example e = exampleSet.getExample(rand);
            if (this.rejectionSampling) {
                r = this.random.nextDouble();
            } else {
                weightToAdd = e.getWeight();
            }
            if (!(r <= e.getWeight())) continue;
            Iterator it = hypothesisList.iterator();
            while (it.hasNext()) {
                ((Hypothesis)it.next()).apply(e);
            }
            this.totalWeight += weightToAdd;
            if ((int)e.getLabel() == 1) {
                this.totalPositiveWeight += weightToAdd;
            }
            if (!output.isEmpty()) {
                for (Hypothesis hypo : output) {
                    hypo.apply(e);
                }
            }
            if (!delete.isEmpty()) {
                for (Hypothesis hypo : delete) {
                    hypo.apply(e);
                }
            }
            if ((int)this.totalWeight < nextUpdateValue) continue;
            nextUpdateValue += this.stepsize;
            this.updateLists(hypothesisList, n, this.totalWeight, this.totalPositiveWeight, delta_h_m);
            Iterator iter = hypothesisList.listIterator();
            while (iter.hasNext() && n > 0 && hypothesisList.size() != n) {
                double conf;
                Hypothesis hypo;
                hypo = (Hypothesis)iter.next();
                double util = this.theUtility.utility(this.totalWeight, this.totalPositiveWeight, hypo);
                if (util >= (conf = this.theUtility.confidenceIntervall(this.totalWeight, this.totalPositiveWeight, hypo, delta_h_m)) + this.maxRest.getUtility() + this.maxRest.getConfidence() - epsilon && this.bestList.contains(hypo)) {
                    results.addLast(new Result(hypo.clone(), this.totalWeight, this.totalPositiveWeight, util, conf));
                    output.addLast(hypo);
                    iter.remove();
                    delta_h = delta / (2.0 * (double)hypothesisList.size());
                    delta_h_m = delta / (2.0 * (double)hypothesisList.size() * Math.ceil(m / (double)this.stepsize));
                    if (--n == 0) continue;
                    this.updateLists(hypothesisList, n, this.totalWeight, this.totalPositiveWeight, delta_h_m);
                    continue;
                }
                if (!(util <= this.minBest.getUtility() - this.minBest.getConfidence() - conf)) continue;
                delete.addLast(hypo);
                iter.remove();
                delta_h = delta / (2.0 * (double)hypothesisList.size());
                delta_h_m = delta / (2.0 * (double)hypothesisList.size() * Math.ceil(m / (double)this.stepsize));
                if (!hypo.equals(this.maxRest.getHypothesis()) || hypothesisList.size() <= n) continue;
                this.updateLists(hypothesisList, n, this.totalWeight, this.totalPositiveWeight, delta_h_m);
            }
        } while (n != 0 && hypothesisList.size() != n && !(this.theUtility.confidenceIntervall(this.totalWeight, delta_h) <= epsilon / 2.0));
        if (n > 0) {
            if (this.bestList.isEmpty()) {
                this.updateLists(hypothesisList, n, this.totalWeight, this.totalPositiveWeight, delta_h_m);
            }
            while (!this.bestList.isEmpty()) {
                Hypothesis hypo = this.bestList.removeFirst();
                double util = this.theUtility.utility(this.totalWeight, this.totalPositiveWeight, hypo);
                double conf = this.theUtility.confidenceIntervall(this.totalWeight, this.totalPositiveWeight, hypo, delta_h_m);
                if (conf > epsilon / 2.0) {
                    conf = epsilon / 2.0;
                }
                results.addLast(new Result(hypo.clone(), this.totalWeight, this.totalPositiveWeight, util, conf));
            }
        } else {
            this.currentDelta += delta / 2.0;
        }
        hypothesisList.addAll(delete);
        hypothesisList.addAll(output);
        return results;
    }

    public ContingencyMatrix reweight(ExampleSet exampleSet, Model model, boolean normalize) throws OperatorException {
        exampleSet = model.apply(exampleSet);
        WeightedPerformanceMeasures wpm = new WeightedPerformanceMeasures(exampleSet);
        WeightedPerformanceMeasures.reweightExamples(exampleSet, wpm.getContingencyMatrix(), false);
        if (normalize) {
            double maxWeight = Double.NEGATIVE_INFINITY;
            for (Example e : exampleSet) {
                if (!(e.getWeight() > maxWeight)) continue;
                maxWeight = e.getWeight();
            }
            for (Example e : exampleSet) {
                e.setValue(e.getAttributes().getWeight(), e.getWeight() / maxWeight);
            }
        }
        PredictionModel.removePredictedLabel(exampleSet);
        return wpm.getContingencyMatrix();
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = this.getInput(ExampleSet.class);
        if (eSet.getAttributes().getLabel() == null) {
            throw new UserError((Operator)this, 105, new Object[0]);
        }
        if (eSet.getAttributes().size() == 0) {
            throw new UserError((Operator)this, 106, new Object[0]);
        }
        CapabilityCheck check = new CapabilityCheck(this, com.rapidminer.tools.Tools.booleanValue(System.getProperty("rapidminer.general.capabilities.warn"), true));
        check.checkLearnerCapabilities(this, eSet);
        for (Attribute attribute : eSet.getAttributes()) {
            if (attribute.isNominal()) continue;
            throw new UserError((Operator)this, 103, this.getName(), attribute.getName());
        }
        this.random = RandomGenerator.getGlobalRandomGenerator();
        this.epsilon = this.getParameterAsDouble(PARAMETER_EPSILON);
        this.currentDelta = this.getParameterAsDouble(PARAMETER_DELTA);
        this.stepsize = this.getParameterAsInt(PARAMETER_STEPSIZE);
        this.large = this.getParameterAsInt(PARAMETER_LARGE);
        this.useKBS = this.getParameterAsBoolean(PARAMETER_USE_KBS);
        this.rejectionSampling = this.getParameterAsBoolean(PARAMETER_REJECTION_SAMPLING);
        this.numberOfSolutions = 1;
        this.iterations = this.getParameterAsInt(PARAMETER_ITERATIONS);
        this.useful_criterion = this.getParameterAsInt(PARAMETER_USEFUL_CRITERION);
        this.min_utility_pruning = this.getParameterAsDouble(PARAMETER_MIN_UTILITY_PRUNING);
        this.min_utility_useful = this.getParameterAsDouble(PARAMETER_MIN_UTILITY_USEFUL);
        this.useBinomial = this.getParameterAsBoolean(PARAMETER_USE_BINOMIAL);
        this.maxComplexity = this.getParameterAsInt(PARAMETER_MAX_COMPLEXITY);
        this.minComplexity = this.getParameterAsInt(PARAMETER_MIN_COMPLEXITY);
        this.forceIterations = this.getParameterAsBoolean(PARAMETER_FORCE_ITERATIONS);
        this.resetWeights = this.getParameterAsBoolean(PARAMETER_RESET_WEIGHTS);
        this.exampleFactor = this.getParameterAsDouble(PARAMETER_EXAMPLE_FACTOR);
        if (this.minComplexity > this.maxComplexity) {
            throw new UserError((Operator)this, 116, PARAMETER_MAX_COMPLEXITY, this.maxComplexity);
        }
        this.label = eSet.getAttributes().getLabel();
        Tools.createWeightAttribute(eSet);
        this.gssResult = new IGSSResult(eSet);
        this.regularAttributes = new Attribute[eSet.getAttributes().size()];
        int counter = 0;
        for (Attribute attribute : eSet.getAttributes()) {
            this.regularAttributes[counter++] = attribute;
        }
        this.seed = new Rule(this.regularAttributes, this.label, this.rejectionSampling, this.getParameterAsBoolean(PARAMETER_GENERATE_ALL_HYPOTHESIS));
        int utility_type = this.getParameterAsInt(PARAMETER_UTILITY_FUNCTION);
        switch (utility_type) {
            case 0: {
                this.theUtility = new Accuracy(this.gssResult.getPriors(), this.large);
                break;
            }
            case 1: {
                this.theUtility = new Linear(this.gssResult.getPriors(), this.large);
                break;
            }
            case 2: {
                this.theUtility = new Squared(this.gssResult.getPriors(), this.large);
                break;
            }
            case 3: {
                this.theUtility = new Binomial(this.gssResult.getPriors(), this.large);
                break;
            }
            case 4: {
                this.theUtility = new WRAcc(this.gssResult.getPriors(), this.large);
            }
        }
        LinkedList<Model> results = new LinkedList<Model>();
        Model model = this.learn(eSet);
        results.add(model);
        IOObject[] resultArray = new IOObject[results.size()];
        results.toArray(resultArray);
        return resultArray;
    }

    @Override
    public Model learn(ExampleSet exampleSet) throws OperatorException {
        LinkedList<Hypothesis> hypothesisList = this.seed.init(this.minComplexity);
        LinkedList<GSSModel> allModels = new LinkedList<GSSModel>();
        int currentComplexity = this.minComplexity;
        boolean binomialTestPerformed = false;
        boolean switchedInThisIteration = false;
        Utility utilityStorage = this.theUtility;
        LinkedList<BayBoostBaseModelInfo> modelInfo = new LinkedList<BayBoostBaseModelInfo>();
        LinkedList<Result> allResultsOfCurrentComplexity = new LinkedList<Result>();
        LinkedList<Hypothesis> deletedHypothesis = new LinkedList<Hypothesis>();
        int i = 0;
        while (i < this.iterations) {
            for (Hypothesis hypo : hypothesisList) {
                hypo.reset();
            }
            double deltaForGSS = 2.0 * this.currentDelta / (3.0 * (double)(this.iterations - i));
            double deltaForPruning = this.currentDelta / (3.0 * (double)(this.iterations - i));
            this.currentDelta = this.currentDelta - deltaForGSS - deltaForPruning;
            LinkedList<Result> currentResults = new LinkedList<Result>();
            currentResults.addAll(this.gss(exampleSet, hypothesisList, deltaForGSS, this.epsilon));
            Hypothesis h = ((Result)currentResults.getFirst()).getHypothesis();
            double[] precisions = new double[2];
            if (h.getPrediction() == 1) {
                precisions[1] = h.getPositiveWeight() / h.getCoveredWeight();
                precisions[0] = 1.0 - precisions[1];
            } else {
                precisions[0] = h.getPositiveWeight() / h.getCoveredWeight();
                precisions[1] = 1.0 - precisions[1];
            }
            GSSModel model = new GSSModel(exampleSet, h, precisions);
            boolean increaseComplexity = false;
            if (!this.isUseful((Result)currentResults.getFirst(), allResultsOfCurrentComplexity, this.useful_criterion, exampleSet, this.MIN_MODEL_NUMBER) || allModels.contains(model)) {
                if (!binomialTestPerformed && this.useBinomial) {
                    this.theUtility = new Binomial(this.gssResult.getPriors(), this.large);
                    binomialTestPerformed = true;
                    switchedInThisIteration = true;
                } else if (currentComplexity < this.maxComplexity) {
                    increaseComplexity = true;
                    ++currentComplexity;
                    this.theUtility = utilityStorage;
                    binomialTestPerformed = false;
                } else if (!this.forceIterations) break;
            }
            if (increaseComplexity) {
                if (!this.useKBS) {
                    hypothesisList.addAll(deletedHypothesis);
                    deletedHypothesis = new LinkedList();
                }
                LinkedList<Hypothesis> prunedList = new LinkedList();
                prunedList = this.prune(hypothesisList, this.min_utility_pruning, this.totalWeight, this.totalPositiveWeight, deltaForPruning);
                hypothesisList = new LinkedList();
                hypothesisList.addAll(this.generate(prunedList));
                allResultsOfCurrentComplexity = new LinkedList();
                if (this.resetWeights) {
                    Tools.createWeightAttribute(exampleSet);
                }
            } else if (!switchedInThisIteration) {
                allModels.addLast(model);
                this.gssResult.addResult((Result)currentResults.getFirst());
                this.currentDelta += deltaForPruning;
                ContingencyMatrix contingencyMatrix = null;
                if (this.useKBS) {
                    contingencyMatrix = this.reweight(exampleSet, model, this.rejectionSampling);
                } else {
                    WeightedPerformanceMeasures wpm = new WeightedPerformanceMeasures(exampleSet);
                    contingencyMatrix = wpm.getContingencyMatrix();
                    int hypoIndex = hypothesisList.indexOf(((Result)currentResults.getFirst()).getHypothesis());
                    deletedHypothesis.addLast(hypothesisList.remove(hypoIndex));
                }
                modelInfo.addLast(new BayBoostBaseModelInfo(model, contingencyMatrix));
                allResultsOfCurrentComplexity.addLast((Result)currentResults.getFirst());
            } else {
                switchedInThisIteration = false;
            }
            ++i;
        }
        double[] priors = new double[2];
        priors[1] = this.gssResult.getPriors()[1];
        priors[0] = this.gssResult.getPriors()[0];
        return new BayBoostModel(exampleSet, modelInfo, priors);
    }

    public boolean isUseful(Result current, LinkedList<Result> otherResults, int criterion, ExampleSet exampleSet, int min_model_number) {
        boolean result = true;
        switch (criterion) {
            case 0: {
                double worstUtility = current.getUtility() - current.getConfidence();
                if (worstUtility < this.min_utility_useful) {
                    result = false;
                    break;
                }
                result = true;
                break;
            }
            case 1: {
                double utility = current.getUtility();
                if (utility < this.min_utility_useful) {
                    result = false;
                    break;
                }
                result = true;
                break;
            }
            case 2: {
                double bestUtility = current.getUtility() + current.getConfidence();
                if (bestUtility < this.min_utility_useful) {
                    result = false;
                    break;
                }
                result = true;
                break;
            }
            case 3: {
                if (otherResults.size() == 0 || otherResults.size() < min_model_number) {
                    return true;
                }
                double sum = 0.0;
                for (Result r : otherResults) {
                    sum += r.getTotalWeight();
                }
                double average = sum / (double)otherResults.size();
                result = current.getTotalWeight() < this.exampleFactor * average;
            }
        }
        return result;
    }

    public LinkedList<Hypothesis> prune(LinkedList<Hypothesis> hypoList, double minUtility, double totalWeight, double totalPositiveWeight, double delta_p) {
        double delta_hp = delta_p / (double)hypoList.size();
        ListIterator it = hypoList.listIterator();
        while (it.hasNext()) {
            Hypothesis hypo = (Hypothesis)it.next();
            double upperBound = this.theUtility.getUpperBound(totalWeight, totalPositiveWeight, hypo, delta_hp);
            if (!(upperBound < minUtility)) continue;
            it.remove();
        }
        return hypoList;
    }

    public LinkedList<Hypothesis> generate(LinkedList<Hypothesis> oldHypothesis) {
        LinkedList<Hypothesis> newHypothesis = new LinkedList<Hypothesis>();
        while (!oldHypothesis.isEmpty()) {
            Hypothesis hypo = oldHypothesis.removeFirst();
            if (!hypo.canBeRefined()) continue;
            newHypothesis.addAll(hypo.refine());
        }
        return newHypothesis;
    }

    public static double log2(double arg) {
        return Math.log(arg) / Math.log(2.0);
    }

    @Override
    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
            return true;
        }
        if (lc == LearnerCapability.BINOMINAL_ATTRIBUTES) {
            return true;
        }
        return lc == LearnerCapability.BINOMINAL_CLASS;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{Model.class, IGSSResult.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_EPSILON, "approximation parameter", 0.01, 1.0, 0.04));
        types.add(new ParameterTypeDouble(PARAMETER_DELTA, "desired confidence", 0.01, 1.0, 0.1));
        types.add(new ParameterTypeDouble(PARAMETER_MIN_UTILITY_PRUNING, "minimum utility used for pruning", -1.0, 1.0, 0.0));
        types.add(new ParameterTypeDouble(PARAMETER_MIN_UTILITY_USEFUL, "minimum utility for the usefulness of a rule", -1.0, 1.0, 0.0));
        types.add(new ParameterTypeInt(PARAMETER_STEPSIZE, "the number of examples drawn before the next hypothesis update", 1, 10000, 100));
        types.add(new ParameterTypeInt(PARAMETER_LARGE, "the number of examples a hypothesis must cover before normal approximation is used", 1, 10000, 100));
        types.add(new ParameterTypeInt(PARAMETER_MAX_COMPLEXITY, "the maximum complexity of hypothesis", 1, 10, 1));
        types.add(new ParameterTypeInt(PARAMETER_MIN_COMPLEXITY, "the minimum complexity of hypothesis", 1, 10, 1));
        types.add(new ParameterTypeInt(PARAMETER_ITERATIONS, "the number of iterations", 1, 50, 10));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_BINOMIAL, "Switch to binomial utility funtion before increasing complexity", false));
        types.add(new ParameterTypeCategory(PARAMETER_UTILITY_FUNCTION, "the utility function to be used", Utility.UTILITY_TYPES, 4));
        types.add(new ParameterTypeBoolean(PARAMETER_USE_KBS, "use kbs to reweight examples after each iteration", true));
        types.add(new ParameterTypeBoolean(PARAMETER_REJECTION_SAMPLING, "use rejection sampling instead of weighted examples", true));
        types.add(new ParameterTypeCategory(PARAMETER_USEFUL_CRITERION, "criterion to decide if the complexity is increased ", CRITERION_TYPES, 1));
        types.add(new ParameterTypeDouble(PARAMETER_EXAMPLE_FACTOR, "used by example criterion to determine usefulness of a hypothesis", 1.0, 5.0, 1.5));
        types.add(new ParameterTypeBoolean(PARAMETER_FORCE_ITERATIONS, "make all iterations even if termination criterion is met", false));
        types.add(new ParameterTypeBoolean(PARAMETER_GENERATE_ALL_HYPOTHESIS, "generate h->Y+/Y- or h->Y+ only.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_RESET_WEIGHTS, "Set weights back to 1 when complexity is increased.", false));
        return types;
    }
}

