/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.io.BytewiseExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeSingle;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.att.AttributeSet;
import com.rapidminer.tools.math.sampling.OrderedSamplingWithoutReplacement;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPSSExampleSource
extends BytewiseExampleSource {
    public static final String PARAMETER_ATTRIBUTE_NAMING_MODE = "attribute_naming_mode";
    public static final String PARAMETER_USE_VALUE_LABELS = "use_value_labels";
    public static final String PARAMETER_RECODE_USER_MISSINGS = "recode_user_missings";
    public static final String PARAMETER_SAMPLE_RATIO = "sample_ratio";
    public static final String PARAMETER_SAMPLE_SIZE = "sample_size";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static final String SPSS_FILE_SUFFIX = "sav";
    public static final int USE_VAR_NAME = 0;
    public static final int USE_VAR_LABEL = 1;
    public static final int USE_VAR_NAME_LABELED = 2;
    public static final int USE_VAR_LABEL_NAMED = 3;
    public static final String[] ATTRIBUTE_NAMING_MODES = new String[]{"name", "label", "name (label)", "label (name)"};
    private static final int CODE_HEADER = 608586802;
    private static final int LENGTH_HEADER = 176;
    private static final int INDEX_CODE_HEADER = 0;
    private static final int INDEX_HEADER_PRODUCT_NAME = 4;
    private static final int LENGTH_HEADER_PRODUCT_NAME = 60;
    private static final int INDEX_HEADER_LAYOUT_CODE = 64;
    private static final int CODE_HEADER_LAYOUT_CODE = 2;
    private static final int INDEX_HEADER_CASE_SIZE = 68;
    private static final int INDEX_HEADER_COMPRESSED = 72;
    private static final int INDEX_HEADER_WEIGHT_INDEX = 76;
    private static final int INDEX_HEADER_NUMBER_OF_CASES = 80;
    private static final int INDEX_HEADER_BIAS = 84;
    private static final int INDEX_HEADER_DATE = 92;
    private static final int LENGTH_HEADER_DATE = 9;
    private static final int INDEX_HEADER_TIME = 101;
    private static final int LENGTH_HEADER_TIME = 8;
    private static final int INDEX_HEADER_DATASET_LABEL = 109;
    private static final int LENGTH_HEADER_DATASET_LABEL = 64;
    private static final int CODE_VARIABLE = 2;
    private static final int LENGTH_VARIABLE = 32;
    private static final int INDEX_VARIABLE_TYPE = 4;
    private static final int INDEX_VARIABLE_LABELED = 8;
    private static final int INDEX_VARIABLE_NUMBER_OF_MISSING_VALUES = 12;
    private static final int INDEX_VARIABLE_PRINT_FORMAT = 16;
    private static final int INDEX_VARIABLE_NAME = 24;
    private static final int LENGTH_VARIABLE_NAME = 8;
    private static final int FORMAT_DATE = 20;
    private static final int FORMAT_EDATE = 38;
    private static final int FORMAT_SDATE = 39;
    private static final int FORMAT_TIME = 21;
    private static final int FORMAT_DATETIME = 22;
    private static final int CODE_VALUE_LABEL = 3;
    private static final int CODE_VALUE_LABEL_VARIABLE = 4;
    private static final int CODE_DOCUMENT = 6;
    private static final int LENGTH_DOCUMENT_LINE = 80;
    private static final int CODE_INFORMATION_HEADER = 7;
    private static final int LENGTH_INFORMATION_HEADER = 12;
    private static final int INDEX_INFORMATION_HEADER_SUBTYPE = 0;
    private static final int INDEX_INFORMATION_HEADER_SIZE = 4;
    private static final int INDEX_INFORMATION_HEADER_COUNT = 8;
    private static final int CODE_INFORMATION_HEADER_SUBTYPE_MACHINE_32 = 3;
    private static final int LENGTH_INFORMATION_HEADER_SUBTYPE_MACHINE_32 = 32;
    private static final int CODE_INFORMATION_HEADER_SUBTYPE_MACHINE_64 = 4;
    private static final int LENGTH_INFORMATION_HEADER_SUBTYPE_MACHINE_64 = 24;
    private static final int CODE_INFORMATION_HEADER_AUXILIARY_VARIABLE_PARAMETERS = 11;
    private static final int LENGTH_INFORMATION_HEADER_SINGLE_AUXILIARY_VARIABLE_PARAMETERS = 12;
    private static final int CODE_LONG_VARIABLE_NAMES = 13;
    private static final int CODE_LONG_VARIABLE_NAME_RECORDS_DIVIDER = 9;
    private static final int CODE_DICTIONARY_TERMINATION = 999;
    private static final int LENGTH_COMMAND_CODE_BLOCK = 8;
    private static final int CODE_COMMAND_CODE_IGNORED = 0;
    private static final int CODE_COMMAND_CODE_EOF = 252;
    private static final int CODE_COMMAND_CODE_NOT_COMPRESSIBLE = 253;
    private static final int CODE_COMMAND_CODE_ALL_SPACES_STRING = 254;
    private static final int CODE_COMMAND_CODE_SYSTEM_MISSING = 255;
    private static final int LENGTH_VALUE_BLOCK = 8;
    private static final long GREGORIAN_CALENDAR_OFFSET_IN_MILLISECONDS = -12219379200000L;

    public SPSSExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    protected String getFileSuffix() {
        return SPSS_FILE_SUFFIX;
    }

    @Override
    protected ExampleSet readStream(InputStream inputStream, DataRowFactory dataRowFactory) throws IOException, UndefinedParameterError {
        int i;
        int attributeNamingMode = this.getParameterAsInt(PARAMETER_ATTRIBUTE_NAMING_MODE);
        boolean useValueLabels = this.getParameterAsBoolean(PARAMETER_USE_VALUE_LABELS);
        boolean recodeUserMissings = this.getParameterAsBoolean(PARAMETER_RECODE_USER_MISSINGS);
        int sampleSize = this.getParameterAsInt(PARAMETER_SAMPLE_SIZE);
        double sampleRatio = this.getParameterAsDouble(PARAMETER_SAMPLE_RATIO);
        RandomGenerator randomGenerator = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        byte[] buffer = new byte[500];
        boolean reverseEndian = false;
        this.read(inputStream, buffer, 176);
        if (this.extractInt(buffer, 0, false) != 608586802) {
            throw new IOException("Wrong file format");
        }
        String productName = this.extractString(buffer, 4, 60);
        int layoutCode = this.extractInt(buffer, 64, false);
        if (layoutCode != 2 && (layoutCode = this.extractInt(buffer, 64, reverseEndian = true)) != 2) {
            throw new IOException("Wrong file format");
        }
        int caseSize = this.extractInt(buffer, 68, reverseEndian);
        boolean compressed = this.extractInt(buffer, 72, reverseEndian) == 1;
        int weightIndex = this.extractInt(buffer, 76, reverseEndian);
        int numberOfExamples = this.extractInt(buffer, 80, reverseEndian);
        double bias = this.extractDouble(buffer, 84, reverseEndian);
        String date = this.extractString(buffer, 92, 9);
        String time = this.extractString(buffer, 101, 8);
        String dataSetLabel = this.extractString(buffer, 109, 64);
        StringBuffer logMessage = new StringBuffer("SPSSExampleSource starts reading..." + Tools.getLineSeparator());
        logMessage.append(String.valueOf(compressed ? "" : "un") + "compressed, written by  " + productName + "  at " + time + ", " + date + Tools.getLineSeparator());
        if (dataSetLabel.equals("")) {
            logMessage.append("no file label, ");
        } else {
            logMessage.append("file label is " + dataSetLabel + Tools.getLineSeparator());
        }
        logMessage.append("contains " + numberOfExamples + " examples, case size is " + caseSize + "x8=" + caseSize * 8 + " Bytes" + Tools.getLineSeparator());
        logMessage.append("weight index is " + weightIndex + Tools.getLineSeparator());
        this.log(logMessage.toString());
        LinkedList<Variable> variables = new LinkedList<Variable>();
        LinkedHashMap<Integer, Integer> variableNrTranslations = new LinkedHashMap<Integer, Integer>();
        int variableNr = 0;
        int i2 = 0;
        while (i2 < caseSize) {
            this.read(inputStream, buffer, 32);
            if (this.extractInt(buffer, 0, reverseEndian) != 2) {
                throw new IOException("file corrupt (missing variable definitions)");
            }
            Variable variable = new Variable();
            variable.type = this.extractInt(buffer, 4, reverseEndian);
            variable.labeled = this.extractInt(buffer, 8, reverseEndian) == 1;
            variable.numberOfMissingValues = this.extractInt(buffer, 12, reverseEndian);
            variable.printFormat = (0xFF0000 & this.extractInt(buffer, 16, reverseEndian)) >> 16;
            variable.name = this.extractString(buffer, 24, 8);
            if (variable.labeled) {
                int labelLength;
                this.read(inputStream, buffer, 32, 4);
                int adjLabelLength = labelLength = this.extractInt(buffer, 32, reverseEndian);
                if (labelLength % 4 != 0) {
                    adjLabelLength = labelLength + 4 - labelLength % 4;
                }
                this.read(inputStream, buffer, adjLabelLength);
                variable.label = this.extractString(buffer, 0, labelLength);
            }
            if (variable.numberOfMissingValues != 0) {
                this.read(inputStream, buffer, variable.numberOfMissingValues * 8);
                variable.missingValues = new double[variable.numberOfMissingValues];
                int j = 0;
                while (j < variable.numberOfMissingValues) {
                    ((Variable)variable).missingValues[j] = this.extractDouble(buffer, j * 8, reverseEndian);
                    ++j;
                }
            }
            if (variable.type != -1) {
                variables.add(variable);
                variableNrTranslations.put(i2, variableNr);
                ++variableNr;
            }
            ++i2;
        }
        boolean valueLabelsRead = false;
        LinkedHashMap<Double, String> valueLabels = null;
        boolean terminated = false;
        block33: do {
            int count = 0;
            this.read(inputStream, buffer, 4);
            int recordType = this.extractInt(buffer, 0, reverseEndian);
            switch (recordType) {
                case 3: {
                    this.read(inputStream, buffer, 4);
                    count = this.extractInt(buffer, 0, reverseEndian);
                    valueLabels = new LinkedHashMap<Double, String>();
                    i = 0;
                    while (i < count) {
                        this.read(inputStream, buffer, 8);
                        double labelValue = this.extractDouble(buffer, 0, reverseEndian);
                        this.read(inputStream, buffer, 1);
                        byte labelLength = buffer[0];
                        int adjLabelLength = labelLength + 8 - labelLength % 8 - 1;
                        this.read(inputStream, buffer, adjLabelLength);
                        String labelLabel = this.extractString(buffer, 0, adjLabelLength);
                        valueLabels.put(labelValue, labelLabel);
                        ++i;
                    }
                    valueLabelsRead = true;
                    break;
                }
                case 4: {
                    if (!valueLabelsRead) {
                        throw new IOException("Wrong file format: value labels have not been read");
                    }
                    valueLabelsRead = false;
                    this.read(inputStream, buffer, 4);
                    count = this.extractInt(buffer, 0, reverseEndian);
                    i = 0;
                    while (i < count) {
                        this.read(inputStream, buffer, 4);
                        int variableNr2 = (Integer)variableNrTranslations.get(this.extractInt(buffer, 0, reverseEndian) - 1);
                        if (variableNr2 < variables.size()) {
                            Variable variable = (Variable)variables.get(variableNr2);
                            variable.valueLabels = valueLabels;
                        }
                        ++i;
                    }
                    continue block33;
                }
                case 6: {
                    this.read(inputStream, buffer, 4);
                    count = this.extractInt(buffer, 0, reverseEndian);
                    i = 0;
                    while (i < count) {
                        this.read(inputStream, buffer, 80);
                        ++i;
                    }
                    continue block33;
                }
                case 7: {
                    this.read(inputStream, buffer, 0, 12);
                    int subType = this.extractInt(buffer, 0, reverseEndian);
                    int size = this.extractInt(buffer, 4, reverseEndian);
                    count = this.extractInt(buffer, 8, reverseEndian);
                    switch (subType) {
                        case 3: {
                            this.read(inputStream, buffer, 32);
                            break;
                        }
                        case 4: {
                            this.read(inputStream, buffer, 24);
                            break;
                        }
                        case 11: {
                            int i3 = 0;
                            while (i3 < variables.size()) {
                                this.read(inputStream, buffer, 12);
                                Variable variable = (Variable)variables.get(i3);
                                variable.measure = this.extractInt(buffer, 0, reverseEndian);
                                ++i3;
                            }
                            continue block33;
                        }
                        case 13: {
                            buffer = new byte[count * size];
                            this.read(inputStream, buffer, count * size);
                            String longVariableNamesString = new String(buffer);
                            String[] longVariableNamePairs = longVariableNamesString.split(new String(new char[]{'\t'}));
                            int i4 = 0;
                            while (i4 < longVariableNamePairs.length) {
                                String[] keyLongVariablePair = longVariableNamePairs[i4].split("=");
                                if (keyLongVariablePair.length == 2) {
                                    for (Variable variable : variables) {
                                        if (!variable.name.equals(keyLongVariablePair[0])) continue;
                                        variable.name = keyLongVariablePair[1];
                                    }
                                }
                                ++i4;
                            }
                            buffer = new byte[500];
                            break;
                        }
                        default: {
                            buffer = new byte[count * size];
                            this.read(inputStream, buffer, count * size);
                            buffer = new byte[500];
                            break;
                        }
                    }
                    continue block33;
                }
                case 999: {
                    this.read(inputStream, buffer, 4);
                    terminated = true;
                    break;
                }
            }
        } while (!terminated);
        AttributeSet attributeSet = new AttributeSet();
        Attribute attribute = null;
        i = 0;
        while (i < variables.size()) {
            Variable variable = (Variable)variables.get(i);
            String attributeName = null;
            if (variable.label == null) {
                variable.label = variable.name;
            }
            switch (attributeNamingMode) {
                case 0: {
                    attributeName = variable.name;
                    break;
                }
                case 1: {
                    attributeName = variable.label;
                    break;
                }
                case 2: {
                    attributeName = String.valueOf(variable.name) + " (" + variable.label + ")";
                    break;
                }
                case 3: {
                    attributeName = String.valueOf(variable.label) + " (" + variable.name + ")";
                    break;
                }
                default: {
                    attributeName = variable.name;
                }
            }
            if (variable.type == 0) {
                if (variable.isDateVariable()) {
                    attribute = AttributeFactory.createAttribute(attributeName, 10);
                } else if (variable.isTimeVariable()) {
                    attribute = AttributeFactory.createAttribute(attributeName, 11);
                } else if (variable.isDateTimeVariable()) {
                    attribute = AttributeFactory.createAttribute(attributeName, 9);
                } else {
                    switch (variable.measure) {
                        case 1: {
                            attribute = AttributeFactory.createAttribute(attributeName, 1);
                            break;
                        }
                        case 2: {
                            attribute = AttributeFactory.createAttribute(attributeName, 1);
                            break;
                        }
                        case 3: {
                            attribute = AttributeFactory.createAttribute(attributeName, 2);
                            break;
                        }
                        default: {
                            if (useValueLabels && variable.valueLabels != null) {
                                attribute = AttributeFactory.createAttribute(attributeName, 1);
                                break;
                            }
                            attribute = AttributeFactory.createAttribute(attributeName, 2);
                            break;
                        }
                    }
                }
            } else {
                attribute = AttributeFactory.createAttribute(attributeName, 5);
            }
            if (attribute.isNominal() && variable.valueLabels != null) {
                for (Double numericValue : variable.valueLabels.keySet()) {
                    boolean missing = false;
                    if (recodeUserMissings) {
                        int j = 0;
                        while (j < variable.numberOfMissingValues) {
                            if (numericValue == variable.missingValues[j]) {
                                missing = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (missing) continue;
                    if (useValueLabels) {
                        attribute.getMapping().mapString((String)variable.valueLabels.get(numericValue));
                        continue;
                    }
                    attribute.getMapping().mapString(Double.toString(numericValue));
                }
            }
            attributeSet.addAttribute(attribute);
            ++i;
        }
        OrderedSamplingWithoutReplacement sampling = null;
        sampling = sampleSize != -1 ? new OrderedSamplingWithoutReplacement(randomGenerator, numberOfExamples, sampleSize) : new OrderedSamplingWithoutReplacement(randomGenerator, numberOfExamples, sampleRatio);
        Attribute weight = weightIndex == 0 ? null : attributeSet.getAttribute((Integer)variableNrTranslations.get(weightIndex - 1));
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes());
        int commandCodeCounter = 0;
        int bytesRead = 0;
        int i5 = 0;
        while (i5 < numberOfExamples) {
            int j;
            String[] values = new String[variables.size()];
            if (!compressed) {
                j = 0;
                while (j < variables.size()) {
                    this.read(inputStream, buffer, 8);
                    values[j] = Double.toString(this.extractDouble(buffer, 0, reverseEndian));
                    ++j;
                }
            } else {
                j = 0;
                while (j < variables.size()) {
                    block91: {
                        boolean readValue = false;
                        String value = null;
                        Variable variable = (Variable)variables.get(j);
                        do {
                            if (commandCodeCounter % 8 == 0) {
                                commandCodeCounter = 0;
                                bytesRead = this.read(inputStream, buffer, 0, 8);
                                if (bytesRead == -1) break block91;
                            }
                            int commandCode = 0xFF & buffer[commandCodeCounter];
                            switch (commandCode) {
                                case 0: {
                                    break;
                                }
                                case 252: {
                                    int k = commandCodeCounter + 1;
                                    while (k < 8) {
                                        buffer[k] = 0;
                                        ++k;
                                    }
                                    break;
                                }
                                case 253: {
                                    String label;
                                    bytesRead = this.read(inputStream, buffer, 8, 8);
                                    if (bytesRead == -1) {
                                        throw new IOException("file corrupt (data inconsistency)");
                                    }
                                    if (variable.type == 0) {
                                        double numericValue = this.extractDouble(buffer, 8, reverseEndian);
                                        if (variable.isDateVariable() || variable.isTimeVariable() || variable.isDateTimeVariable()) {
                                            numericValue = (long)numericValue * 1000L + -12219379200000L;
                                        }
                                        value = Double.toString(numericValue);
                                        if (variable.measure != 3 && useValueLabels && variable.valueLabels != null) {
                                            value = label = (String)variable.valueLabels.get(numericValue);
                                        }
                                        if (recodeUserMissings) {
                                            int k = 0;
                                            while (k < variable.numberOfMissingValues) {
                                                if (Tools.isEqual(numericValue, variable.missingValues[k])) {
                                                    value = null;
                                                }
                                                ++k;
                                            }
                                        }
                                        readValue = true;
                                        break;
                                    }
                                    if ((value = value == null ? new String(buffer, 8, 8) : String.valueOf(value) + new String(buffer, 8, 8)).length() < ((Variable)variables.get(j)).type) break;
                                    value = value.trim();
                                    readValue = true;
                                    break;
                                }
                                case 254: {
                                    String string = value = value == null ? String.valueOf("        ") : value.concat(String.valueOf("        "));
                                    if (value.length() < ((Variable)variables.get(j)).type) break;
                                    value = value.trim();
                                    readValue = true;
                                    break;
                                }
                                case 255: {
                                    value = null;
                                    readValue = true;
                                    break;
                                }
                                default: {
                                    String label;
                                    double numericValue = (double)commandCode - bias;
                                    value = Double.toString(numericValue);
                                    if (variable.measure != 3 && useValueLabels && variable.valueLabels != null) {
                                        value = label = (String)variable.valueLabels.get(numericValue);
                                    }
                                    if (recodeUserMissings) {
                                        int k = 0;
                                        while (k < variable.numberOfMissingValues) {
                                            if (Tools.isEqual(numericValue, variable.missingValues[k])) {
                                                value = null;
                                            }
                                            ++k;
                                        }
                                    }
                                    readValue = true;
                                }
                            }
                            ++commandCodeCounter;
                        } while (!readValue);
                        values[j] = value;
                    }
                    ++j;
                }
            }
            if (sampling == null) {
                table.addDataRow(dataRowFactory.create(values, table.getAttributes()));
            } else if (sampling.acceptElement()) {
                table.addDataRow(dataRowFactory.create(values, table.getAttributes()));
            }
            ++i5;
        }
        inputStream.close();
        ExampleSet exampleSet = table.createExampleSet();
        exampleSet.getAttributes().setWeight(weight);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory(PARAMETER_ATTRIBUTE_NAMING_MODE, "Determines which SPSS variable properties should be used for attribute naming.", ATTRIBUTE_NAMING_MODES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_USE_VALUE_LABELS, "Use SPSS value labels as values.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean(PARAMETER_RECODE_USER_MISSINGS, "Recode SPSS user missings to missing values.", true);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble(PARAMETER_SAMPLE_RATIO, "The fraction of the data set which should be read (1 = all; only used if sample_size = -1)", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_SAMPLE_SIZE, "The exact number of samples which should be read (-1 = all; if not -1, sample_ratio will not have any effect)", -1, Integer.MAX_VALUE, -1);
        type.setExpert(true);
        types.add(type);
        type = new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (for sampling by ratio, -1: use global).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(true);
        types.add(type);
        return types;
    }

    private class Variable {
        private static final int TYPE_NUMERICAL = 0;
        private static final int MEASURE_NOMINAL = 1;
        private static final int MEASURE_ORDINAL = 2;
        private static final int MEASURE_CONTINUOUS = 3;
        private int type;
        private boolean labeled;
        private int printFormat;
        private int numberOfMissingValues;
        private String name;
        private String label;
        private double[] missingValues;
        private LinkedHashMap<Double, String> valueLabels;
        private int measure;

        private Variable() {
        }

        private boolean isDateVariable() {
            return this.printFormat == 20 || this.printFormat == 38 || this.printFormat == 39;
        }

        private boolean isTimeVariable() {
            return this.printFormat == 21;
        }

        private boolean isDateTimeVariable() {
            return this.printFormat == 22;
        }
    }
}

