/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSetWriter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExampleSetWriter
extends AbstractExampleSetWriter {
    public static final String PARAMETER_EXCEL_FILE = "excel_file";

    public ExcelExampleSetWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet write(ExampleSet exampleSet) throws OperatorException {
        File file = this.getParameterAsFile(PARAMETER_EXCEL_FILE, true);
        WorkbookSettings ws = new WorkbookSettings();
        ws.setLocale(Locale.US);
        try {
            WritableWorkbook workbook = Workbook.createWorkbook((File)file, (WorkbookSettings)ws);
            WritableSheet s = workbook.createSheet("RapidMiner Data", 0);
            this.writeDataSheet(s, exampleSet);
            workbook.write();
            workbook.close();
        }
        catch (Exception e) {
            throw new UserError((Operator)this, 303, file.getName(), e.getMessage());
        }
        return exampleSet;
    }

    private void writeDataSheet(WritableSheet s, ExampleSet exampleSet) throws WriteException {
        WritableFont wf = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat cf = new WritableCellFormat(wf);
        Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
        int counter = 0;
        while (a.hasNext()) {
            Attribute attribute = a.next();
            s.addCell((WritableCell)new Label(counter++, 0, attribute.getName(), (CellFormat)cf));
        }
        NumberFormat nf = new NumberFormat("#.0");
        WritableCellFormat nfCell = new WritableCellFormat((DisplayFormat)nf);
        WritableFont wf2 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD);
        WritableCellFormat cf2 = new WritableCellFormat(wf2);
        int rowCounter = 1;
        for (Example example : exampleSet) {
            a = exampleSet.getAttributes().allAttributes();
            int columnCounter = 0;
            while (a.hasNext()) {
                Attribute attribute = a.next();
                if (!Double.isNaN(example.getValue(attribute))) {
                    if (attribute.isNominal()) {
                        s.addCell((WritableCell)new Label(columnCounter, rowCounter, this.replaceForbiddenChars(example.getValueAsString(attribute)), (CellFormat)cf2));
                    } else {
                        Number number = new Number(columnCounter, rowCounter, example.getValue(attribute), (CellFormat)nfCell);
                        s.addCell((WritableCell)number);
                    }
                }
                ++columnCounter;
            }
            ++rowCounter;
        }
    }

    private String replaceForbiddenChars(String originalValue) {
        return originalValue.replace('\u0000', ' ');
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_EXCEL_FILE, "The Excel spreadsheet file which should be written.", "xls", false));
        return types;
    }
}

