/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeParser;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeConstructionsLoader
extends Operator {
    public static final String PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE = "attribute_constructions_file";
    public static final String PARAMETER_KEEP_ALL = "keep_all";
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class};

    public AttributeConstructionsLoader(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(ExampleSet.class).clone();
        boolean keepAll = this.getParameterAsBoolean(PARAMETER_KEEP_ALL);
        LinkedList<Attribute> oldAttributes = new LinkedList<Attribute>();
        for (Attribute attribute : exampleSet.getAttributes()) {
            oldAttributes.add(attribute);
        }
        File file = this.getParameterAsFile(PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE);
        if (file != null) {
            AttributeParser parser = new AttributeParser();
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(file);
                    parser.generateAll(this, exampleSet, in);
                }
                catch (IOException e) {
                    throw new UserError((Operator)this, (Throwable)e, 302, file.getName(), e.getMessage());
                }
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        this.logError("Cannot close stream to file " + file);
                    }
                }
            }
        }
        if (!keepAll) {
            for (Attribute oldAttribute : oldAttributes) {
                exampleSet.getAttributes().remove(oldAttribute);
            }
        }
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_ATTRIBUTE_CONSTRUCTIONS_FILE, "Filename for the attribute constructions file.", "att", false));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ALL, "If set to true, all the original attributes are kept, otherwise they are removed from the example set.", false));
        return types;
    }
}

