/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.features.Population;
import com.rapidminer.operator.features.PopulationOperator;
import com.rapidminer.operator.features.selection.AbstractGeneticAlgorithm;
import com.rapidminer.operator.features.selection.SelectionCrossover;
import com.rapidminer.operator.features.weighting.VarianceAdaption;
import com.rapidminer.operator.features.weighting.WeightingMutation;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionaryWeighting
extends AbstractGeneticAlgorithm {
    public static final String PARAMETER_MUTATION_VARIANCE = "mutation_variance";
    public static final String PARAMETER_1_5_RULE = "1_5_rule";
    public static final String PARAMETER_BOUNDED_MUTATION = "bounded_mutation";
    public static final String PARAMETER_P_CROSSOVER = "p_crossover";
    public static final String PARAMETER_CROSSOVER_TYPE = "crossover_type";
    public static final String PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS = "initialize_with_input_weights";
    private WeightingMutation weighting = null;

    public EvolutionaryWeighting(OperatorDescription description) {
        super(description);
    }

    @Override
    public PopulationOperator getCrossoverPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        return new SelectionCrossover(this.getParameterAsInt(PARAMETER_CROSSOVER_TYPE), this.getParameterAsDouble(PARAMETER_P_CROSSOVER), this.getRandom(), 1, eSet.getAttributes().size(), -1);
    }

    @Override
    public PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws UndefinedParameterError {
        this.weighting = new WeightingMutation(this.getParameterAsDouble(PARAMETER_MUTATION_VARIANCE), this.getParameterAsBoolean(PARAMETER_BOUNDED_MUTATION), this.getRandom());
        return this.weighting;
    }

    @Override
    protected List<PopulationOperator> getPostProcessingPopulationOperators(ExampleSet eSet) throws UndefinedParameterError {
        LinkedList<PopulationOperator> otherPostOps = new LinkedList<PopulationOperator>();
        if (this.getParameterAsBoolean(PARAMETER_1_5_RULE)) {
            otherPostOps.add(new VarianceAdaption(this.weighting, eSet.getAttributes().size()));
        }
        return otherPostOps;
    }

    @Override
    public Population createInitialPopulation(ExampleSet exampleSet) throws UndefinedParameterError {
        double[] weights;
        Population initPop = new Population();
        int numberOfIndividuals = this.getParameterAsInt("population_size");
        double[] initialWeights = null;
        if (this.getParameterAsBoolean(PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS)) {
            AttributeWeights inputWeights = null;
            try {
                inputWeights = this.getInput(AttributeWeights.class);
                initialWeights = new double[exampleSet.getAttributes().size()];
                int index = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    double weight = inputWeights.getWeight(attribute.getName());
                    if (Double.isNaN(weight)) {
                        weight = this.getRandom().nextDouble();
                    }
                    initialWeights[index++] = weight;
                }
                initPop.add(new Individual(initialWeights));
            }
            catch (MissingIOObjectException index) {
                // empty catch block
            }
        }
        if (initialWeights != null) {
            while (initPop.getNumberOfIndividuals() < numberOfIndividuals / 2) {
                weights = new double[exampleSet.getAttributes().size()];
                int w = 0;
                while (w < weights.length) {
                    weights[w] = Math.min(1.0, Math.max(0.0, initialWeights[w] + this.getRandom().nextGaussian() * 0.1));
                    ++w;
                }
                initPop.add(new Individual(weights));
            }
        }
        while (initPop.getNumberOfIndividuals() < numberOfIndividuals) {
            weights = new double[exampleSet.getAttributes().size()];
            int w = 0;
            while (w < weights.length) {
                weights[w] = this.getRandom().nextDouble();
                ++w;
            }
            initPop.add(new Individual(weights));
        }
        return initPop;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_MUTATION_VARIANCE, "The (initial) variance for each mutation.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean(PARAMETER_1_5_RULE, "If set to true, the 1/5 rule for variance adaption is used.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_BOUNDED_MUTATION, "If set to true, the weights are bounded between 0 and 1.", false));
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_P_CROSSOVER, "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_CROSSOVER_TYPE, "Type of the crossover.", SelectionCrossover.CROSSOVER_TYPES, 1));
        types.add(new ParameterTypeBoolean(PARAMETER_INITIALIZE_WITH_INPUT_WEIGHTS, "Indicates if this operator should look for attribute weights in the given input and use the input weights of all known attributes as starting point for the optimization.", false));
        return types;
    }
}

