/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.look.fc.Bookmark;
import com.rapidminer.gui.look.fc.BookmarkIO;
import com.rapidminer.gui.tools.DefaultFrameIconProvider;
import com.rapidminer.gui.tools.ErrorDialog;
import com.rapidminer.gui.tools.FrameIconProvider;
import com.rapidminer.gui.tools.SimpleFileFilter;
import com.rapidminer.gui.tools.syntax.SyntaxStyle;
import com.rapidminer.gui.tools.syntax.SyntaxUtilities;
import com.rapidminer.gui.tools.syntax.TextAreaDefaults;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Image;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingTools {
    private static final int TOOL_TIP_LINE_LENGTH = 100;
    public static final int TABLE_ROW_EXTRA_HEIGHT = 4;
    public static final int TABLE_WITH_COMPONENTS_ROW_EXTRA_HEIGHT = 10;
    public static final Color DARKEST_YELLOW = new Color(250, 219, 172);
    public static final Color DARK_YELLOW = new Color(250, 226, 190);
    public static final Color LIGHT_YELLOW = new Color(250, 233, 207);
    public static final Color LIGHTEST_YELLOW = new Color(250, 240, 225);
    public static final Color TRANSPARENT_YELLOW = new Color(255, 245, 230, 190);
    public static final Color VERY_DARK_BLUE = new Color(172, 172, 212);
    public static final Color DARKEST_BLUE = new Color(182, 202, 242);
    public static final Color DARK_BLUE = new Color(199, 213, 242);
    public static final Color LIGHT_BLUE = new Color(216, 224, 242);
    public static final Color LIGHTEST_BLUE = new Color(233, 236, 242);
    public static final Color RAPID_I_ORANGE = new Color(242, 146, 0);
    public static final Color RAPID_I_BROWN = new Color(97, 66, 11);
    public static final Color LIGHTEST_RED = new Color(250, 210, 210);
    public static final Color BROWN_FONT_COLOR = new Color(63, 53, 24);
    public static final Color LIGHT_BROWN_FONT_COLOR = new Color(113, 103, 74);
    private static List<Image> allFrameIcons = new LinkedList<Image>();
    private static FrameIconProvider frameIconProvider;
    private static final String DEFAULT_FRAME_ICON_BASE_NAME = "rapidminer_frame_icon_";
    private static String iconType;

    static {
        iconType = RapidMinerGUI.LOOK_AND_FEELS[0];
        SwingTools.setupFrameIcons(DEFAULT_FRAME_ICON_BASE_NAME);
    }

    public static void setFrameIconProvider(FrameIconProvider _frameIconProvider) {
        frameIconProvider = _frameIconProvider;
        SwingTools.reloadFrameIcons();
    }

    public static void setupFrameIcons(String frameIconBaseName) {
        SwingTools.setFrameIconProvider(new DefaultFrameIconProvider(frameIconBaseName));
        SwingTools.reloadFrameIcons();
    }

    private static void reloadFrameIcons() {
        allFrameIcons = frameIconProvider == null ? new LinkedList<Image>() : frameIconProvider.getFrameIcons();
    }

    public static List<Image> getFrameIconList() {
        return allFrameIcons;
    }

    public static void setFrameIcon(JFrame frame) {
        Method iconImageMethod = null;
        try {
            iconImageMethod = frame.getClass().getMethod("setIconImages", List.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iconImageMethod != null) {
            try {
                iconImageMethod.invoke((Object)frame, allFrameIcons);
            }
            catch (Throwable e) {
                if (allFrameIcons.size() > 0) {
                    frame.setIconImage(allFrameIcons.get(0));
                }
            }
        } else if (allFrameIcons.size() > 0) {
            frame.setIconImage(allFrameIcons.get(0));
        }
    }

    public static void setDialogIcon(JDialog dialog) {
        Method iconImageMethod = null;
        try {
            iconImageMethod = dialog.getClass().getMethod("setIconImages", List.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (iconImageMethod != null) {
            try {
                iconImageMethod.invoke((Object)dialog, allFrameIcons);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static GradientPaint makeRedPaint(double width, double height) {
        return new GradientPaint(0.0f, 0.0f, new Color(200, 50, 50), (float)width / 2.0f, (float)height / 2.0f, new Color(255, 100, 100), true);
    }

    public static GradientPaint makeBluePaint(double width, double height) {
        return new GradientPaint(0.0f, 0.0f, LIGHT_BLUE, (float)width / 2.0f, (float)height / 2.0f, LIGHTEST_BLUE, true);
    }

    public static GradientPaint makeYellowPaint(double width, double height) {
        return new GradientPaint(0.0f, 0.0f, LIGHT_YELLOW, (float)width / 2.0f, (float)height / 2.0f, LIGHTEST_YELLOW, true);
    }

    public static void setIconType(String newIconType) {
        iconType = newIconType;
    }

    public static ImageIcon createIcon(String iconName) {
        return SwingTools.createImage("icons/" + iconType + "/" + iconName);
    }

    public static ImageIcon createImage(String imageName) {
        URL url = Tools.getResource(imageName);
        if (url != null) {
            return new ImageIcon(url);
        }
        LogService.getGlobal().log("Cannot load image '" + imageName + "': icon will not be displayed", 2);
        return null;
    }

    public static String transformToolTipText(String description) {
        return SwingTools.transformToolTipText(description, true, 100);
    }

    public static String transformToolTipText(String description, boolean addHTMLTags, int lineLength) {
        String[] lines;
        String completeText = description.trim();
        StringBuffer result = new StringBuffer();
        if (addHTMLTags) {
            result.append("<html>");
        }
        completeText = Tools.transformAllLineSeparators(completeText);
        String[] stringArray = lines = completeText.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            boolean first = true;
            while (text.length() > lineLength) {
                int spaceIndex = text.indexOf(" ", lineLength);
                if (!first) {
                    result.append("<br>");
                }
                first = false;
                if (spaceIndex >= 0) {
                    result.append(text.substring(0, spaceIndex));
                    text = text.substring(spaceIndex + 1);
                    continue;
                }
                result.append(text);
                text = "";
            }
            if (!first && text.length() > 0) {
                result.append("<br>");
            }
            result.append(text);
            result.append("<br>");
            ++n2;
        }
        if (addHTMLTags) {
            result.append("</html>");
        }
        return result.toString();
    }

    public static String getStringFromClassArray(Class[] classes) {
        StringBuffer outputString = new StringBuffer();
        if (classes == null) {
            outputString.append("none");
        } else {
            int i = 0;
            while (i < classes.length) {
                if (i != 0) {
                    outputString.append(", ");
                }
                outputString.append(Tools.classNameWOPackage(classes[i]));
                ++i;
            }
        }
        if (outputString.length() == 0) {
            outputString.append("none");
        }
        return outputString.toString();
    }

    public static String addLinebreaks(String message) {
        String[] lines;
        if (message == null) {
            return null;
        }
        String completeText = message.trim();
        StringBuffer result = new StringBuffer();
        completeText = Tools.transformAllLineSeparators(completeText);
        String[] stringArray = lines = completeText.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            boolean first = true;
            while (text.length() > 100) {
                int spaceIndex = text.indexOf(" ", 100);
                if (!first) {
                    result.append(Tools.getLineSeparator());
                }
                first = false;
                if (spaceIndex >= 0) {
                    result.append(text.substring(0, spaceIndex));
                    text = text.substring(spaceIndex + 1);
                    continue;
                }
                result.append(text);
                text = "";
            }
            if (!first && text.length() > 0) {
                result.append(Tools.getLineSeparator());
            }
            result.append(text);
            result.append(Tools.getLineSeparator());
            ++n2;
        }
        return result.toString();
    }

    public static void showVerySimpleErrorMessage(String message) {
        JOptionPane.showMessageDialog(RapidMinerGUI.getMainFrame(), SwingTools.addLinebreaks(message), "Error", 0);
    }

    public static void showSimpleErrorMessage(String message, Throwable e) {
        JOptionPane.showMessageDialog(RapidMinerGUI.getMainFrame(), String.valueOf(SwingTools.addLinebreaks(message)) + Tools.classNameWOPackage(e.getClass()) + " caught:" + Tools.getLineSeparator() + SwingTools.addLinebreaks(e.getMessage()), "Error", 0);
    }

    public static void showFinalErrorMessage(String message, Throwable e) {
        ErrorDialog dialog = ErrorDialog.create(message, e);
        dialog.setLocationRelativeTo(RapidMinerGUI.getMainFrame());
        dialog.setVisible(true);
    }

    public static File chooseFile(Component parent, File file, boolean open, String extension, String extensionDescription) {
        return SwingTools.chooseFile(parent, file, open, false, extension, extensionDescription);
    }

    public static File chooseFile(Component parent, File file, boolean open, boolean onlyDirs, String extension, String extensionDescription) {
        String[] stringArray;
        String[] stringArray2;
        if (extension == null) {
            stringArray2 = null;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = extension;
        }
        if (extensionDescription == null) {
            stringArray = null;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = extensionDescription;
        }
        return SwingTools.chooseFile(parent, file, open, onlyDirs, stringArray2, stringArray);
    }

    private static File chooseFile(Component parent, File file, boolean open, boolean onlyDirs, String[] extensions, String[] extensionDescriptions) {
        FileFilter[] filters = null;
        if (extensions != null) {
            filters = new FileFilter[extensions.length];
            int i = 0;
            while (i < extensions.length) {
                filters[i] = new SimpleFileFilter(String.valueOf(extensionDescriptions[i]) + " (*." + extensions[i] + ")", "." + extensions[i]);
                ++i;
            }
        }
        return SwingTools.chooseFile(parent, file, open, onlyDirs, filters);
    }

    private static File chooseFile(Component parent, File file, boolean open, boolean onlyDirs, FileFilter[] fileFilters) {
        if (parent == null) {
            parent = RapidMinerGUI.getMainFrame();
        }
        JFileChooser fileChooser = SwingTools.createFileChooser(file, onlyDirs, fileFilters);
        int returnValue = open ? fileChooser.showOpenDialog(parent) : fileChooser.showSaveDialog(parent);
        switch (returnValue) {
            case 0: {
                File parentFile;
                File selectedFile = fileChooser.getSelectedFile();
                FileFilter selectedFilter = fileChooser.getFileFilter();
                String extension = null;
                if (selectedFilter instanceof SimpleFileFilter) {
                    SimpleFileFilter simpleFF = (SimpleFileFilter)selectedFilter;
                    extension = simpleFF.getExtension();
                }
                if (extension != null && !selectedFile.getAbsolutePath().toLowerCase().endsWith(extension.toLowerCase())) {
                    selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + extension);
                }
                if (selectedFile != null && (parentFile = selectedFile.getParentFile()) != null) {
                    List<Bookmark> bookmarks = null;
                    File bookmarksFile = new File(ParameterService.getUserRapidMinerDir(), ".bookmarks");
                    if (bookmarksFile.exists()) {
                        bookmarks = BookmarkIO.readBookmarks(bookmarksFile);
                        Iterator<Bookmark> b = bookmarks.iterator();
                        while (b.hasNext()) {
                            Bookmark bookmark = b.next();
                            if (!bookmark.getName().equals("--- Last Directory")) continue;
                            b.remove();
                        }
                        bookmarks.add(new Bookmark("--- Last Directory", parentFile.getAbsolutePath()));
                        Collections.sort(bookmarks);
                        BookmarkIO.writeBookmarks(bookmarks, bookmarksFile);
                    }
                }
                return selectedFile;
            }
        }
        return null;
    }

    public static JFileChooser createFileChooser(File file, boolean onlyDirs, FileFilter[] fileFilters) {
        File directory = null;
        if (file != null) {
            directory = file.isDirectory() ? file : file.getAbsoluteFile().getParentFile();
        } else {
            File processFile = null;
            MainFrame mainFrame = RapidMinerGUI.getMainFrame();
            if (mainFrame != null) {
                File file2 = processFile = mainFrame.getProcess() != null ? mainFrame.getProcess().getProcessFile() : null;
            }
            if (processFile != null) {
                directory = processFile.getAbsoluteFile().getParentFile();
            } else {
                directory = ParameterService.getUserWorkspace();
                if (directory == null) {
                    FileSystemView fsv = FileSystemView.getFileSystemView();
                    directory = fsv.getDefaultDirectory();
                }
            }
        }
        JFileChooser fileChooser = new JFileChooser(directory);
        if (onlyDirs) {
            fileChooser.setFileSelectionMode(1);
        }
        if (fileFilters != null) {
            fileChooser.setAcceptAllFileFilterUsed(true);
            int i = 0;
            while (i < fileFilters.length) {
                fileChooser.addChoosableFileFilter(fileFilters[i]);
                ++i;
            }
        }
        if (file != null) {
            fileChooser.setSelectedFile(file);
        }
        return fileChooser;
    }

    public static JPanel createTextPanel(String title, String text) {
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("<html><h2>" + title + "</h2>" + (text != null ? "<p>" + text + "</p>" : "") + "</html>");
        label.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
        label.setFont(label.getFont().deriveFont(0));
        panel.add((Component)label, "North");
        return panel;
    }

    public static String html2RapidMinerText(String html) {
        if (html == null) {
            return null;
        }
        String result = html.replaceAll("<", "#ylt#");
        result = result.replaceAll(">", "#ygt#");
        result = result.replaceAll("\"", "#yquot#");
        result = result.replaceAll(Tools.getLineSeparator(), "");
        return result;
    }

    public static String text2DisplayHtml(String text) {
        String result = "<html><head><style type=text/css>body { font-family:sans-serif; font-size:12pt; }</style></head><body>" + text + "</body></html>";
        result = SwingTools.text2SimpleHtml(result);
        result = result.replaceAll("#yquot#", "&quot;");
        while (result.indexOf("<icon>") != -1) {
            int startIndex = result.indexOf("<icon>");
            int endIndex = result.indexOf("</icon>");
            String start = result.substring(0, startIndex);
            String end = result.substring(endIndex + 7);
            String icon = result.substring(startIndex + 6, endIndex).trim().toLowerCase();
            URL url = Tools.getResource("icons/" + iconType + "/" + icon + ".png");
            result = url != null ? String.valueOf(start) + "<img src=\"" + url + "\">" + end : String.valueOf(start) + end;
        }
        return result;
    }

    public static String text2SimpleHtml(String htmlText) {
        if (htmlText == null) {
            return null;
        }
        String replaceString = htmlText.replaceAll("#ygt#", ">");
        replaceString = replaceString.replaceAll("#ylt#", "<");
        StringBuffer result = new StringBuffer();
        boolean afterClose = true;
        int currentLineLength = 0;
        int i = 0;
        while (i < replaceString.length()) {
            char c = replaceString.charAt(i);
            if (!afterClose || c != ' ') {
                if (c == '<' && !afterClose) {
                    result.append(Tools.getLineSeparator());
                    currentLineLength = 0;
                }
                afterClose = false;
                result.append(c);
                if (++currentLineLength > 70 && c == ' ') {
                    result.append(Tools.getLineSeparator());
                    currentLineLength = 0;
                }
                if (c == '>') {
                    result.append(Tools.getLineSeparator());
                    currentLineLength = 0;
                    afterClose = true;
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static Color getPointColor(double value) {
        return new Color(Color.HSBtoRGB((float)(0.68 * (1.0 - value)), 1.0f, 1.0f));
    }

    public static Color getPointColor(double value, double max, double min) {
        value = (value - min) / (max - min);
        return SwingTools.getPointColor(value);
    }

    public static TextAreaDefaults getTextAreaDefaults() {
        TextAreaDefaults defaults = TextAreaDefaults.getDefaults();
        defaults.styles = SwingTools.getSyntaxStyles();
        return defaults;
    }

    public static SyntaxStyle[] getSyntaxStyles() {
        SyntaxStyle[] styles = SyntaxUtilities.getDefaultSyntaxStyles();
        styles[1] = new SyntaxStyle(new Color(0x990033), true, false);
        styles[2] = new SyntaxStyle(Color.black, true, false);
        styles[6] = new SyntaxStyle(Color.black, false, true);
        styles[7] = new SyntaxStyle(new Color(255, 51, 204), false, false);
        styles[8] = new SyntaxStyle(new Color(255, 51, 204), false, false);
        styles[3] = new SyntaxStyle(new Color(51, 51, 255), false, false);
        styles[4] = new SyntaxStyle(new Color(51, 51, 255), false, false);
        styles[5] = new SyntaxStyle(new Color(0x990033), false, true);
        styles[9] = new SyntaxStyle(Color.black, false, true);
        styles[10] = new SyntaxStyle(Color.red, false, true);
        return styles;
    }
}

