/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.attributeeditor.actions;

import com.rapidminer.gui.attributeeditor.AttributeEditor;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class LoadDataAction
extends AbstractAction {
    private static final long serialVersionUID = -2111723479390457757L;
    private static final String ICON_NAME = "data_add.png";
    private static final Icon[] ICONS = new Icon[IconSize.values().length];
    private AttributeEditor attributeEditor;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconSize size = iconSizeArray[n2];
            LoadDataAction.ICONS[counter++] = SwingTools.createIcon(String.valueOf(size.getSize()) + "/" + ICON_NAME);
            ++n2;
        }
    }

    public LoadDataAction(AttributeEditor attributeEditor, IconSize size) {
        super("Load Data...", ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "Open data file and append additional columns to table");
        this.putValue("MnemonicKey", 68);
        this.attributeEditor = attributeEditor;
    }

    public void actionPerformed(ActionEvent e) {
        File file = SwingTools.chooseFile((Component)this.attributeEditor, null, true, null, null);
        if (file != null) {
            try {
                this.attributeEditor.readData(file, 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.attributeEditor, e.toString(), "Error loading " + file, 0);
            }
        }
    }
}

