/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.actions;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.JDBCDriverTable;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.jdbc.DriverInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CheckForJDBCDriversAction
extends AbstractAction {
    private static final long serialVersionUID = -3497263063489866721L;
    private static final String ICON_NAME = "data_connection.png";
    private static final Icon[] ICONS = new Icon[IconSize.values().length];
    private MainFrame mainFrame;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconSize size = iconSizeArray[n2];
            CheckForJDBCDriversAction.ICONS[counter++] = SwingTools.createIcon(String.valueOf(size.getSize()) + "/" + ICON_NAME);
            ++n2;
        }
    }

    public CheckForJDBCDriversAction(MainFrame mainFrame, IconSize size) {
        super("Show Database Drivers...", ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "List all available JDBC database drivers which are currently available to RapidMiner");
        this.putValue("MnemonicKey", 74);
        this.mainFrame = mainFrame;
    }

    public void actionPerformed(ActionEvent e) {
        final JDialog dialog = new JDialog(this.mainFrame, "Available Database Drivers", true);
        dialog.setLayout(new BorderLayout());
        JTextArea driverInfoText = new JTextArea("The currently available JDBC drivers are listed below. Please make sure to copy missing drivers into the directory lib/jdbc and restart RapidMiner in order to make additional drivers available.");
        driverInfoText.setLineWrap(true);
        driverInfoText.setWrapStyleWord(true);
        driverInfoText.setEditable(false);
        driverInfoText.setBackground(dialog.getBackground());
        dialog.add((Component)driverInfoText, "North");
        DriverInfo[] drivers = DatabaseService.getAllDriverInfos();
        JDBCDriverTable driverTable = new JDBCDriverTable(drivers);
        dialog.add((Component)new JScrollPane(driverTable), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        closeButton.setMargin(new Insets(4, 4, 4, 4));
        buttonPanel.add(closeButton);
        dialog.add((Component)buttonPanel, "South");
        dialog.pack();
        dialog.setLocationRelativeTo(this.mainFrame);
        dialog.setVisible(true);
    }
}

