/*
 * Decompiled with CFR 0.152.
 */
import com.rapidminer.RapidMiner;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.OperatorService;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class OperatorListCreator {
    public static void main(String[] argv) throws IOException {
        RapidMiner.init();
        GroupTree tree = OperatorService.getGroups();
        PrintWriter out = new PrintWriter(new FileWriter(argv[0]));
        OperatorListCreator.printGroup(out, "", tree);
        out.close();
    }

    public static void printMainGroups(PrintWriter out, GroupTree tree) {
        Set<OperatorDescription> descriptions = tree.getOperatorDescriptions();
        LinkedList<OperatorDescription> descriptionsList = new LinkedList<OperatorDescription>(descriptions);
        Collections.sort(descriptionsList);
        for (OperatorDescription description : descriptionsList) {
            out.println(description.getName());
        }
        LinkedList<GroupTree> subgroups = new LinkedList<GroupTree>(tree.getSubGroups());
        Collections.sort(subgroups);
        for (GroupTree subtree : subgroups) {
            out.println("--------------------------");
            out.println(subtree.getName());
            out.println("--------------------------");
            descriptions = subtree.getAllOperatorDescriptions();
            descriptionsList = new LinkedList<OperatorDescription>(descriptions);
            Collections.sort(descriptionsList);
            for (OperatorDescription description : descriptionsList) {
                out.println(description.getName());
            }
        }
    }

    public static void printGroup(PrintWriter out, String parentName, GroupTree tree) {
        out.println("--------------------------");
        if (parentName.length() > 0) {
            out.println(String.valueOf(parentName) + "." + tree.getName());
        } else {
            out.println(tree.getName());
        }
        out.println("--------------------------");
        Set<OperatorDescription> descriptions = tree.getOperatorDescriptions();
        LinkedList<OperatorDescription> descriptionsList = new LinkedList<OperatorDescription>(descriptions);
        Collections.sort(descriptionsList);
        for (OperatorDescription description : descriptionsList) {
            out.print(description.getName());
            Operator op = null;
            try {
                op = description.createOperatorInstance();
            }
            catch (OperatorCreationException e1) {
                e1.printStackTrace();
            }
            if (op != null && op instanceof Learner) {
                Learner learner = (Learner)((Object)op);
                StringBuffer learnerCapabilities = new StringBuffer();
                Iterator<LearnerCapability> i = LearnerCapability.getAllCapabilities().iterator();
                boolean first = true;
                while (i.hasNext()) {
                    LearnerCapability capability = i.next();
                    try {
                        if (!learner.supportsCapability(capability)) continue;
                        if (!first) {
                            learnerCapabilities.append(", ");
                        }
                        learnerCapabilities.append(capability.getDescription());
                        first = false;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                String result = learnerCapabilities.toString();
                if (result.length() > 0) {
                    out.print("  [" + result + "]");
                }
            }
            out.println();
        }
        LinkedList<GroupTree> subgroups = new LinkedList<GroupTree>(tree.getSubGroups());
        Collections.sort(subgroups);
        for (GroupTree subtree : subgroups) {
            if (parentName.length() > 0) {
                OperatorListCreator.printGroup(out, String.valueOf(parentName) + "." + tree.getName(), subtree);
                continue;
            }
            OperatorListCreator.printGroup(out, tree.getName(), subtree);
        }
    }
}

