/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.matrix;

import com.rapidminer.tools.math.matrix.AbstractMatrix;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSparseMatrix<Ex, Ey>
extends AbstractMatrix<Ex, Ey> {
    private static final long serialVersionUID = -5401611723498335593L;
    private Map<Ex, Map<Ey, Double>> objMap = new HashMap<Ex, Map<Ey, Double>>();
    private Set<Ey> yLabels = new HashSet<Ey>();

    @Override
    public void setEntry(Ex x, Ey y, double v) {
        Map<Ey, Double> objEntries = this.objMap.get(x);
        if (objEntries == null) {
            objEntries = new HashMap<Ey, Double>();
            this.objMap.put(x, objEntries);
        }
        this.yLabels.add(y);
        if (v == 0.0) {
            objEntries.remove(y);
        } else {
            objEntries.put(y, v);
        }
    }

    @Override
    public void incEntry(Ex x, Ey y, double v) {
        double currentValue = this.getEntry(x, y);
        this.setEntry(x, y, currentValue + v);
    }

    @Override
    public double getEntry(Ex x, Ey y) {
        Map<Ey, Double> objEntries = this.objMap.get(x);
        if (objEntries != null) {
            Double val = objEntries.get(y);
            if (val != null) {
                return val;
            }
            return 0.0;
        }
        return 0.0;
    }

    public int getNumYEntries(Ex x) {
        Map<Ey, Double> objEntries = this.objMap.get(x);
        if (objEntries == null) {
            return 0;
        }
        return objEntries.keySet().size();
    }

    @Override
    public int getNumXLabels() {
        return this.objMap.keySet().size();
    }

    @Override
    public Iterator<Ex> getXLabels() {
        return this.objMap.keySet().iterator();
    }

    public Iterator<Ey> getYEntries(Ex x) {
        Map<Ey, Double> objEntries = this.objMap.get(x);
        if (objEntries == null) {
            return new HashSet().iterator();
        }
        return objEntries.keySet().iterator();
    }

    @Override
    public Iterator<Ey> getYLabels() {
        return this.yLabels.iterator();
    }

    @Override
    public int getNumYLabels() {
        return this.yLabels.size();
    }
}

