/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.loganalysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegularExpressionMatcher {
    List<Pattern> patterns = new LinkedList<Pattern>();
    Map<Pattern, String> patternNames = new HashMap<Pattern, String>();

    public RegularExpressionMatcher(List<String[]> pairs) {
        for (String[] pair : pairs) {
            String name = pair[0];
            Pattern p = Pattern.compile(pair[1]);
            this.patterns.add(p);
            this.patternNames.put(p, name);
        }
    }

    public RegularExpressionMatcher(Reader inReader, boolean namedMatches) throws IOException {
        BufferedReader in = new BufferedReader(inReader);
        String line = null;
        while ((line = in.readLine()) != null) {
            if (namedMatches) {
                int pos = line.indexOf(58);
                String name = line.substring(0, pos);
                Pattern p = Pattern.compile(line.substring(pos + 1));
                this.patterns.add(p);
                this.patternNames.put(p, name);
                continue;
            }
            this.patterns.add(Pattern.compile(line));
        }
    }

    public boolean isSubstringMatch(String s) {
        boolean result = false;
        Iterator<Pattern> it = this.patterns.iterator();
        while (it.hasNext() && !result) {
            Pattern p = it.next();
            if (!p.matcher(s).find()) continue;
            result = true;
        }
        return result;
    }

    public String getMatch(String s) {
        Iterator<Pattern> it = this.patterns.iterator();
        String name = null;
        while (it.hasNext() && name == null) {
            Pattern p = it.next();
            Matcher m = p.matcher(s);
            if (!m.matches()) continue;
            name = this.patternNames.get(p);
        }
        return name;
    }
}

