/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.extraction;

import com.rapidminer.operator.extraction.TextExtractor;
import com.rapidminer.operator.extraction.util.RegexPatternIterator;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexExtractor
implements TextExtractor {
    private final String targetTemplate;
    private final Pattern pattern;
    private final String query;

    public RegexExtractor(String query) throws PatternSyntaxException {
        this.query = query;
        int index = query.lastIndexOf(32);
        if (index > 0) {
            this.pattern = Pattern.compile(query.substring(0, index));
            this.targetTemplate = query.substring(index + 1);
        } else {
            this.pattern = Pattern.compile(query);
            this.targetTemplate = "$0";
        }
    }

    public Iterator<String> findPatterns(String s) {
        return new RegexPatternIterator(this.pattern.matcher(s), this.targetTemplate);
    }

    public boolean equals(Object obj) {
        return this.query.equals(obj.toString());
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public String toString() {
        return this.query;
    }
}

