/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.model.MaxentModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.BaseModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenNameFinderModel
extends BaseModel {
    private static final String COMPONENT_NAME = "NameFinderME";
    private static final String MAXENT_MODEL_ENTRY_NAME = "nameFinder.model";

    public TokenNameFinderModel(String languageCode, AbstractModel nameFinderModel, Map<String, Object> resources, Map<String, String> manifestInfoEntries) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries);
        if (!TokenNameFinderModel.isModelValid(nameFinderModel)) {
            throw new IllegalArgumentException("Model not compatible with name finder!");
        }
        this.artifactMap.put(MAXENT_MODEL_ENTRY_NAME, nameFinderModel);
        if (resources.containsKey(MAXENT_MODEL_ENTRY_NAME)) {
            throw new IllegalArgumentException();
        }
        this.artifactMap.putAll(resources);
    }

    public TokenNameFinderModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    public AbstractModel getNameFinderModel() {
        return (AbstractModel)this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME);
    }

    public static boolean isModelValid(MaxentModel model) {
        ArrayList<String> start = new ArrayList<String>();
        ArrayList<String> cont = new ArrayList<String>();
        for (int i = 0; i < model.getNumOutcomes(); ++i) {
            String outcome = model.getOutcome(i);
            if (outcome.endsWith("start")) {
                start.add(outcome.substring(0, outcome.length() - "start".length()));
                continue;
            }
            if (outcome.endsWith("cont")) {
                cont.add(outcome.substring(0, outcome.length() - "cont".length()));
                continue;
            }
            if (outcome.equals("other")) continue;
            return false;
        }
        if (start.size() == 0) {
            return false;
        }
        for (String contPreffix : cont) {
            if (start.contains(contPreffix)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void createArtifactSerializers(Map<String, ArtifactSerializer> serializers) {
        super.createArtifactSerializers(serializers);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(MAXENT_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Token Name Finder model is incomplete!");
        }
    }
}

