/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.conditions.ParameterCondition;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;

public abstract class ParameterType
implements Comparable,
Serializable {
    private static final long serialVersionUID = 5296461242851710130L;
    private String key;
    private String description;
    private boolean expert = true;
    private boolean hidden = false;
    private boolean showRange = true;
    private Collection<ParameterCondition> conditions = new LinkedList<ParameterCondition>();

    public ParameterType(String key, String description) {
        this.key = key;
        this.description = description;
    }

    public abstract String getRange();

    public abstract Object getDefaultValue();

    public abstract void setDefaultValue(Object var1);

    public abstract boolean isNumerical();

    public abstract String getXML(String var1, String var2, String var3, boolean var4);

    public boolean showRange() {
        return this.showRange;
    }

    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
    }

    public String transformNewValue(String value) {
        return value;
    }

    public boolean isExpert() {
        return this.isOptional() && this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public boolean isHidden() {
        boolean conditionsMet = true;
        for (ParameterCondition condition : this.conditions) {
            conditionsMet &= condition.dependencyMet();
        }
        return this.hidden || !conditionsMet;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void registerDependencyCondition(ParameterCondition condition) {
        this.conditions.add(condition);
    }

    public boolean isOptional() {
        boolean becomeMandatory = false;
        for (ParameterCondition condition : this.conditions) {
            if (condition.dependencyMet()) {
                becomeMandatory |= condition.becomeMandatory();
                continue;
            }
            becomeMandatory = false;
            break;
        }
        return !becomeMandatory;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public String toXMLString(Object value) {
        return Tools.escapeXML(this.toString(value));
    }

    public String toString() {
        return String.valueOf(this.key) + " (" + this.description + ")";
    }

    public void illegalValue(Object illegal, Object corrected) {
        LogService.getGlobal().log("Illegal value '" + illegal + "' for parameter '" + this.key + "' has been corrected to '" + corrected.toString() + "'.", 5);
    }

    public int compareTo(Object o) {
        if (!(o instanceof ParameterType)) {
            return 0;
        }
        return this.key.compareTo(((ParameterType)o).key);
    }
}

