/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization.dependencies;

import Jama.Matrix;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.datatable.SimpleDataTableRow;
import com.rapidminer.gui.plotter.PlotterPanel;
import com.rapidminer.gui.tools.CellColorProviderScaled;
import com.rapidminer.gui.tools.ExtendedFixedColumnJTable;
import com.rapidminer.gui.viewer.DataTableViewer;
import com.rapidminer.gui.viewer.NumericalMatrixViewerTableModel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.visualization.dependencies.NumericalMatrix;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RainflowMatrix
extends NumericalMatrix {
    private static final long serialVersionUID = -2316260417823285606L;
    private String[] residuals;

    public RainflowMatrix(String name, String[] columnNames, Matrix matrix, boolean symmetrical, String[] residuals) {
        super(name, columnNames, matrix, symmetrical);
        this.residuals = residuals;
    }

    public Component getVisualizationComponent(IOContainer container) {
        final JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int x = 0;
        while (x < this.getNumberOfColumns()) {
            int y = 0;
            while (y < this.getNumberOfRows()) {
                double value = Math.abs(this.getValue(x, y));
                if (!Double.isNaN(value)) {
                    min = Math.min(min, value);
                    max = Math.max(max, value);
                }
                ++y;
            }
            ++x;
        }
        final ExtendedFixedColumnJTable matrixViewer = ExtendedFixedColumnJTable.createFixedColumnTable(new NumericalMatrixViewerTableModel(this));
        matrixViewer.getMainDataTable().setCellColorProvider(new CellColorProviderScaled(matrixViewer.getMainDataTable(), true, min, max));
        DataTable pairwiseDataTable = this.createPairwiseDataTable();
        final DataTableViewer pairwiseTableViewer = new DataTableViewer(pairwiseDataTable, false);
        pairwiseTableViewer.getTable().setAutoResizeMode(2);
        final PlotterPanel plotterComponent = new PlotterPanel(pairwiseDataTable);
        SimpleDataTable residualTable = new SimpleDataTable("Rainflow Matrix Residuals", new String[]{"Residual Index", "Residual Class"});
        int i = 0;
        while (i < this.getNumberOfColumns()) {
            residualTable.mapString(1, this.getColumnName(i));
            ++i;
        }
        int index = 1;
        String[] stringArray = this.residuals;
        int n = this.residuals.length;
        int n2 = 0;
        while (n2 < n) {
            String residual = stringArray[n2];
            residualTable.add(new SimpleDataTableRow(new double[]{index++, residualTable.mapString(1, residual)}));
            ++n2;
        }
        final DataTableViewer residualTableViewer = new DataTableViewer(residualTable, PlotterPanel.DATA_SET_PLOTTER_SELECTION, false, 0, true);
        pairwiseTableViewer.getTable().setAutoResizeMode(2);
        final PlotterPanel residualPlotterComponent = new PlotterPanel(residualTable);
        final JRadioButton matrixButton = new JRadioButton("Matrix View", true);
        matrixButton.setToolTipText("Changes to a table showing the " + this.getName().toLowerCase() + ".");
        matrixButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (matrixButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)matrixViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton pairwiseButton = new JRadioButton("Pairwise " + this.getName(), true);
        pairwiseButton.setToolTipText("Changes to a table showing the " + this.getName().toLowerCase() + " for all pairs.");
        pairwiseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (pairwiseButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)pairwiseTableViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton plotButton = new JRadioButton("Plot View", false);
        plotButton.setToolTipText("Changes to a plot view of the " + this.getName().toLowerCase());
        plotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (plotButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)plotterComponent, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton residualTableButton = new JRadioButton("Residual Table", true);
        residualTableButton.setToolTipText("Changes to a table showing the residuals for all pairs.");
        residualTableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (residualTableButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)residualTableViewer, "Center");
                    mainPanel.repaint();
                }
            }
        });
        final JRadioButton residualPlotButton = new JRadioButton("Residual Plot View", false);
        residualPlotButton.setToolTipText("Changes to a plot view of the " + this.getName().toLowerCase());
        residualPlotButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (residualPlotButton.isSelected()) {
                    mainPanel.remove(1);
                    mainPanel.add((Component)residualPlotterComponent, "Center");
                    mainPanel.repaint();
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(matrixButton);
        group.add(pairwiseButton);
        group.add(plotButton);
        group.add(residualTableButton);
        group.add(residualPlotButton);
        JPanel togglePanel = new JPanel(new FlowLayout(0));
        togglePanel.add(matrixButton);
        togglePanel.add(pairwiseButton);
        togglePanel.add(plotButton);
        togglePanel.add(residualTableButton);
        togglePanel.add(residualPlotButton);
        mainPanel.add((Component)togglePanel, "North");
        mainPanel.add((Component)matrixViewer, "Center");
        return mainPanel;
    }
}

