/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.visualization;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.learner.PredictionModel;
import com.rapidminer.tools.math.LiftDataGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiftChartGenerator
extends Operator {
    public LiftChartGenerator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Model model = this.getInput(Model.class);
        if (exampleSet.getAttributes().getLabel() == null) {
            throw new UserError(this, 105);
        }
        if (!exampleSet.getAttributes().getLabel().isNominal()) {
            throw new UserError((Operator)this, 101, "Lift Charts", exampleSet.getAttributes().getLabel());
        }
        if (exampleSet.getAttributes().getLabel().getMapping().getValues().size() != 2) {
            throw new UserError((Operator)this, 114, "Lift Charts", exampleSet.getAttributes().getLabel());
        }
        if (exampleSet.getAttributes().getPredictedLabel() != null) {
            this.logWarning("Input example already has a predicted label which will be removed.");
            PredictionModel.removePredictedLabel(exampleSet);
        }
        if ((exampleSet = model.apply(exampleSet)).getAttributes().getPredictedLabel() == null) {
            throw new UserError(this, 107);
        }
        LiftDataGenerator liftDataGenerator = new LiftDataGenerator();
        List<double[]> liftPoints = liftDataGenerator.createLiftDataList(exampleSet);
        liftDataGenerator.createLiftChartPlot(liftPoints);
        PredictionModel.removePredictedLabel(exampleSet);
        return new IOObject[]{exampleSet, model};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }
}

