/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SortedExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.transformation.ExampleSetTransformationOperator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Example2AttributePivoting
extends ExampleSetTransformationOperator {
    public static final String PARAMETER_GROUP_ATTRIBUTE = "group_attribute";
    public static final String PARAMETER_INDEX_ATTRIBUTE = "index_attribute";
    public static final String PARAMETER_CONSIDER_WEIGHTS = "consider_weights";
    public static final String PARAMETER_WEIGHT_AGGREGATION = "weight_aggregation";

    public Example2AttributePivoting(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet sourceExampleSet = this.getInput(ExampleSet.class);
        String groupAttributeName = this.getParameterAsString(PARAMETER_GROUP_ATTRIBUTE);
        String indexAttributeName = this.getParameterAsString(PARAMETER_INDEX_ATTRIBUTE);
        boolean considerWeights = this.getParameterAsBoolean(PARAMETER_CONSIDER_WEIGHTS);
        int weightAggregationFunctionIndex = this.getParameterAsInt(PARAMETER_WEIGHT_AGGREGATION);
        Attribute groupAttribute = sourceExampleSet.getAttributes().get(groupAttributeName);
        if (groupAttribute == null) {
            throw new UserError((Operator)this, 111, groupAttributeName);
        }
        Attribute indexAttribute = sourceExampleSet.getAttributes().get(indexAttributeName);
        if (indexAttribute == null) {
            throw new UserError((Operator)this, 111, indexAttributeName);
        }
        Attribute weightAttribute = sourceExampleSet.getAttributes().getWeight();
        SortedExampleSet exampleSet = new SortedExampleSet(sourceExampleSet, groupAttribute, 0);
        Vector<String> indexValues = new Vector<String>();
        Attribute[] attributes = exampleSet.getAttributes().createRegularAttributeArray();
        boolean[] constantAttributeValues = new boolean[attributes.length];
        int i = 0;
        while (i < constantAttributeValues.length) {
            constantAttributeValues[i] = true;
            ++i;
        }
        Example lastExample = null;
        for (Example example : exampleSet) {
            String indexValue;
            if (lastExample != null && lastExample.getValue(groupAttribute) == example.getValue(groupAttribute)) {
                int i2 = 0;
                while (i2 < attributes.length) {
                    Attribute attribute = attributes[i2];
                    if (!(Double.isNaN(lastExample.getValue(attribute)) && Double.isNaN(example.getValue(attribute)) || lastExample.getValue(attribute) == example.getValue(attribute))) {
                        constantAttributeValues[i2] = false;
                    }
                    ++i2;
                }
            }
            if (!indexValues.contains(indexValue = example.getValueAsString(indexAttribute))) {
                indexValues.add(indexValue);
            }
            lastExample = example;
        }
        if (!indexAttribute.isNominal()) {
            Collections.sort(indexValues);
        }
        Vector<String> attributeNames = new Vector<String>();
        Vector<Attribute> newAttributes = new Vector<Attribute>();
        Attribute newWeightAttribute = null;
        if (weightAttribute != null && considerWeights) {
            newWeightAttribute = AttributeFactory.createAttribute(weightAttribute.getName(), 4);
            newAttributes.add(newWeightAttribute);
            attributeNames.add(newWeightAttribute.getName());
        }
        int i3 = 0;
        while (i3 < attributes.length) {
            Attribute attribute = attributes[i3];
            if (!attribute.equals(indexAttribute)) {
                if (constantAttributeValues[i3]) {
                    newAttributes.add(AttributeFactory.createAttribute(attribute.getName(), attribute.getValueType()));
                    attributeNames.add(attribute.getName());
                } else {
                    for (String indexValue : indexValues) {
                        String newAttributeName = String.valueOf(attribute.getName()) + "_" + indexValue;
                        newAttributes.add(AttributeFactory.createAttribute(newAttributeName, attribute.getValueType()));
                        attributeNames.add(newAttributeName);
                    }
                }
            }
            ++i3;
        }
        MemoryExampleTable table = new MemoryExampleTable(newAttributes);
        AggregationFunction aggregationFunction = null;
        if (newWeightAttribute != null && considerWeights) {
            try {
                aggregationFunction = AbstractAggregationFunction.createAggregationFunction(weightAggregationFunctionIndex);
            }
            catch (Exception e) {
                throw new UserError((Operator)this, 904, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[weightAggregationFunctionIndex], e.getMessage());
            }
        }
        lastExample = null;
        double[] data = new double[newAttributes.size()];
        int i4 = 0;
        while (i4 < data.length) {
            data[i4] = Double.NaN;
            ++i4;
        }
        for (Example example : exampleSet) {
            int i5;
            if (lastExample != null && lastExample.getValue(groupAttribute) != example.getValue(groupAttribute)) {
                if (aggregationFunction != null) {
                    data[0] = aggregationFunction.getValue();
                    try {
                        aggregationFunction = AbstractAggregationFunction.createAggregationFunction(weightAggregationFunctionIndex);
                    }
                    catch (Exception e) {
                        throw new UserError((Operator)this, 904, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[weightAggregationFunctionIndex], e.getMessage());
                    }
                }
                table.addDataRow(new DoubleArrayDataRow(data));
                data = new double[newAttributes.size()];
                i5 = 0;
                while (i5 < data.length) {
                    data[i5] = Double.NaN;
                    ++i5;
                }
            }
            if (aggregationFunction != null) {
                aggregationFunction.update(example.getWeight());
            }
            i5 = 0;
            while (i5 < attributes.length) {
                double value;
                Attribute attribute = attributes[i5];
                int newIndex = -1;
                if (constantAttributeValues[i5]) {
                    newIndex = attributeNames.indexOf(attribute.getName());
                } else {
                    String newAttributeName = String.valueOf(attribute.getName()) + "_" + example.getValueAsString(indexAttribute);
                    newIndex = attributeNames.indexOf(newAttributeName);
                }
                if (newIndex != -1 && !Double.isNaN(value = example.getValue(attribute))) {
                    data[newIndex] = attribute.isNominal() ? (double)((Attribute)newAttributes.get(newIndex)).getMapping().mapString(attribute.getMapping().mapIndex((int)value)) : value;
                }
                ++i5;
            }
            lastExample = example;
        }
        if (aggregationFunction != null) {
            data[0] = aggregationFunction.getValue();
        }
        table.addDataRow(new DoubleArrayDataRow(data));
        ExampleSet result = table.createExampleSet();
        if (newWeightAttribute != null) {
            result.getAttributes().setWeight(newWeightAttribute);
        }
        result.recalculateAllAttributeStatistics();
        return new IOObject[]{result};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_GROUP_ATTRIBUTE, "Attribute that groups the examples which form one example after pivoting.", false));
        types.add(new ParameterTypeString(PARAMETER_INDEX_ATTRIBUTE, "Attribute which differentiates examples inside a group.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_CONSIDER_WEIGHTS, "Determines whether weights will be kept and aggregated or ignored.", true));
        types.add(new ParameterTypeCategory(PARAMETER_WEIGHT_AGGREGATION, "Specifies how example weights are aggregated in the groups.", AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 6));
        return types;
    }
}

