/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.preprocessing.filter.ValueReplenishment;
import com.rapidminer.tools.Ontology;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class MissingValueReplenishment
extends ValueReplenishment {
    private static final int NONE = 0;
    private static final int MINIMUM = 1;
    private static final int MAXIMUM = 2;
    private static final int AVERAGE = 3;
    private static final int ZERO = 4;
    private static final int VALUE = 5;
    private static final String[] REPLENISHMENT_NAMES = new String[]{"none", "minimum", "maximum", "average", "zero", "value"};

    public MissingValueReplenishment(OperatorDescription description) {
        super(description);
    }

    public String[] getFunctionNames() {
        return REPLENISHMENT_NAMES;
    }

    public int getDefaultFunction() {
        return 3;
    }

    public int getDefaultColumnFunction() {
        return 3;
    }

    public boolean replenishValue(double currentValue) {
        return Double.isNaN(currentValue);
    }

    public double getReplenishmentValue(int functionIndex, ExampleSet exampleSet, Attribute attribute, double currentValue, String valueString) {
        switch (functionIndex) {
            case 0: {
                return currentValue;
            }
            case 1: {
                return exampleSet.getStatistics(attribute, "minimum");
            }
            case 2: {
                return exampleSet.getStatistics(attribute, "maximum");
            }
            case 3: {
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                    return currentValue;
                }
                if (attribute.isNominal()) {
                    return exampleSet.getStatistics(attribute, "mode");
                }
                return exampleSet.getStatistics(attribute, "average");
            }
            case 4: {
                return 0.0;
            }
            case 5: {
                if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                    String formatString = null;
                    if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 10)) {
                        formatString = "MM/dd/yyyy";
                    } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 11)) {
                        formatString = "hh.mm a";
                    } else if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 9)) {
                        formatString = "MM/dd/yyyy hh.mm a";
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat(formatString, Locale.US);
                    try {
                        Date date = dateFormat.parse(valueString);
                        return date.getTime();
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("Illegal date format, must be '" + formatString + "'");
                    }
                }
                if (attribute.isNominal()) {
                    return attribute.getMapping().mapString(valueString);
                }
                return Double.parseDouble(valueString);
            }
        }
        throw new RuntimeException("Illegal value functionIndex: " + functionIndex);
    }
}

