/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.Condition;
import com.rapidminer.example.set.ConditionCreationException;
import com.rapidminer.example.set.ConditionedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.condition.CombinedInnerOperatorCondition;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SpecificInnerOperatorCondition;
import com.rapidminer.operator.features.weighting.InfoGainWeighting;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.RandomGenerator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingValueImputation
extends OperatorChain {
    public static final String PARAMETER_ORDER = "order";
    public static final String PARAMETER_SORT = "sort";
    public static final String PARAMETER_ITERATE = "iterate";
    public static final String PARAMETER_FILTER_LEARNING_SET = "filter_learning_set";
    public static final String PARAMETER_LEARN_ON_COMPLETE_CASES = "learn_on_complete_cases";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    private static final int CHRONOLOGICAL = 0;
    private static final int RANDOM = 1;
    private static final int NUMBER_OF_MISSING_VALUES = 2;
    private static final int INFORMATION_GAIN = 3;
    private static final String[] orderStrategies = new String[]{"chronological", "random", "number of missing values", "information gain"};
    private static final int ASCENDING = 0;
    private static final String[] sortStrategies = new String[]{"ascending", "descending"};

    public MissingValueImputation(OperatorDescription description) {
        super(description);
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return 2;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        if (this.getNumberOfOperators() == 1) {
            return new SpecificInnerOperatorCondition("Learner", 0, new Class[]{ExampleSet.class}, new Class[]{Model.class});
        }
        CombinedInnerOperatorCondition condition = new CombinedInnerOperatorCondition();
        condition.addCondition(new SpecificInnerOperatorCondition("Filter", 0, new Class[]{ExampleSet.class}, new Class[]{ExampleSet.class}));
        condition.addCondition(new SpecificInnerOperatorCondition("Learner", 1, new Class[]{ExampleSet.class}, new Class[]{Model.class}));
        return condition;
    }

    public Attribute[] getOrderedAttributes(ExampleSet exampleSet, int order, boolean ascending) throws OperatorException {
        Attribute[] sortedAttributes = new Attribute[exampleSet.getAttributes().size()];
        AttributeWeights weights = new AttributeWeights(exampleSet);
        switch (order) {
            case 0: {
                int index = 0;
                for (Attribute attribute : exampleSet.getAttributes()) {
                    weights.setWeight(attribute.getName(), index);
                    ++index;
                }
                break;
            }
            case 1: {
                RandomGenerator randomGenerator = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
                for (Attribute attribute : exampleSet.getAttributes()) {
                    weights.setWeight(attribute.getName(), randomGenerator.nextDouble());
                }
                break;
            }
            case 2: {
                exampleSet.recalculateAllAttributeStatistics();
                for (Attribute attribute : exampleSet.getAttributes()) {
                    weights.setWeight(attribute.getName(), exampleSet.getStatistics(attribute, "unknown"));
                }
                break;
            }
            case 3: {
                InfoGainWeighting infoGainWeightingOperator;
                if (exampleSet.getAttributes().getLabel() == null) {
                    throw new UserError(this, 105);
                }
                try {
                    infoGainWeightingOperator = OperatorService.createOperator(InfoGainWeighting.class);
                }
                catch (OperatorCreationException e) {
                    throw new OperatorException("Cannot create info gain weighting operator which is necessary for ordering the attributes.");
                }
                weights = infoGainWeightingOperator.apply(new IOContainer(exampleSet)).get(AttributeWeights.class);
            }
        }
        String[] attributeNames = new String[weights.size()];
        weights.getAttributeNames().toArray(attributeNames);
        int sortingOrder = ascending ? -1 : 1;
        weights.sortByWeight(attributeNames, sortingOrder, 1);
        int i = 0;
        while (i < attributeNames.length) {
            sortedAttributes[i] = exampleSet.getAttributes().get(attributeNames[i]);
            ++i;
        }
        return sortedAttributes;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        Attribute attribute;
        boolean iterate = this.getParameterAsBoolean(PARAMETER_ITERATE);
        int order = this.getParameterAsInt(PARAMETER_ORDER);
        boolean ascending = this.getParameterAsInt(PARAMETER_SORT) == 0;
        boolean filterLearningSet = this.getParameterAsBoolean(PARAMETER_FILTER_LEARNING_SET);
        boolean learnOnCompleteCases = this.getParameterAsBoolean(PARAMETER_LEARN_ON_COMPLETE_CASES);
        Operator learner = null;
        Operator filter = null;
        if (this.getNumberOfOperators() == 1) {
            learner = this.getOperator(0);
        } else {
            filter = this.getOperator(0);
            learner = this.getOperator(1);
        }
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Attribute label = exampleSet.getAttributes().getLabel();
        if (label != null) {
            exampleSet.getAttributes().setLabel(null);
            exampleSet.getAttributes().remove(label);
        }
        ExampleSet imputationSet = (ExampleSet)exampleSet.clone();
        if (filter != null) {
            imputationSet = filter.apply(new IOContainer((ExampleSet)exampleSet.clone())).get(ExampleSet.class);
        }
        int numberOfAttributes = imputationSet.getAttributes().size();
        Attribute[][] attributePairs = new Attribute[2][numberOfAttributes];
        imputationSet.getAttributes().setLabel(label);
        attributePairs[0] = this.getOrderedAttributes(imputationSet, order, ascending);
        imputationSet.getAttributes().setLabel(null);
        int imputationFailure = 0;
        ExampleSet workingSet = null;
        int i = 0;
        while (i < numberOfAttributes) {
            workingSet = filterLearningSet ? (ExampleSet)imputationSet.clone() : (ExampleSet)exampleSet.clone();
            attribute = attributePairs[0][i];
            workingSet.getAttributes().setLabel(attribute);
            Condition condition = null;
            try {
                condition = ConditionedExampleSet.createCondition("no_missing_labels", workingSet, "");
            }
            catch (ConditionCreationException e) {
                throw new UserError((Operator)this, 904, "no_missing_lables", e.getMessage());
            }
            ConditionedExampleSet learningSet = new ConditionedExampleSet(workingSet, condition);
            if (learnOnCompleteCases) {
                try {
                    condition = ConditionedExampleSet.createCondition("no_missing_attributes", learningSet, "");
                }
                catch (ConditionCreationException e) {
                    throw new UserError((Operator)this, 904, "no_missing_attributes", e.getMessage());
                }
                learningSet = new ConditionedExampleSet(learningSet, condition);
            }
            this.log("Learning imputation model for attribute " + attribute.getName() + " on " + learningSet.size() + " examples.");
            Model model = learner.apply(new IOContainer(learningSet)).get(Model.class);
            workingSet = model.apply(workingSet);
            workingSet.getAttributes().setLabel(null);
            workingSet.getAttributes().addRegular(attribute);
            attributePairs[1][i] = workingSet.getAttributes().getPredictedLabel();
            if (iterate) {
                this.log("Imputating missing values in attribute " + attribute.getName() + ".");
                for (Example example : workingSet) {
                    double value = example.getValue(attribute);
                    if (!Double.isNaN(value)) continue;
                    example.setValue(attribute, example.getPredictedLabel());
                    if (!Double.isNaN(example.getPredictedLabel())) continue;
                    ++imputationFailure;
                }
            }
            if (imputationFailure > 0) {
                this.logWarning("Unable to impute " + imputationFailure + " missing values in attribute " + attribute.getName() + ".");
                imputationFailure = 0;
            }
            workingSet.getAttributes().setPredictedLabel(null);
            ++i;
        }
        if (!iterate) {
            i = 0;
            while (i < numberOfAttributes) {
                imputationFailure = 0;
                attribute = attributePairs[0][i];
                this.log("Imputating missing values in attribute " + attribute.getName() + ".");
                for (Example example : workingSet) {
                    double value = example.getValue(attribute);
                    if (!Double.isNaN(value)) continue;
                    example.setValue(attribute, example.getValue(attributePairs[1][i]));
                    if (!Double.isNaN(example.getValue(attributePairs[1][i]))) continue;
                    ++imputationFailure;
                }
                if (imputationFailure > 0) {
                    this.logWarning("Unable to impute " + imputationFailure + " missing values in attribute " + attribute.getName() + ".");
                    imputationFailure = 0;
                }
                ++i;
            }
        }
        exampleSet.getAttributes().addRegular(label);
        exampleSet.getAttributes().setLabel(label);
        return new IOObject[]{exampleSet};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeCategory(PARAMETER_ORDER, "Order of attributes in which missing values are estimated.", orderStrategies, 0));
        types.add(new ParameterTypeCategory(PARAMETER_SORT, "Sort direction which is used in order strategy.", sortStrategies, 0));
        types.add(new ParameterTypeBoolean(PARAMETER_ITERATE, "Impute missing values immediately after having learned the corresponding concept and iterate.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_FILTER_LEARNING_SET, "Apply filter to learning set in addition to determination which missing values should be substituted.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_LEARN_ON_COMPLETE_CASES, "Learn concepts to impute missing values only on the basis of complete cases (should be used in case learning approach can not handle missing values).", true));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

