/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.gaussianprocess;

import Jama.Matrix;
import com.rapidminer.operator.learner.functions.kernel.rvm.kernel.Kernel;
import java.io.Serializable;

public class Model
implements Serializable {
    private static final long serialVersionUID = 1695426983570182267L;
    private Kernel kernel;
    private double[][] basisVectors;
    private Matrix alpha;
    private boolean regression;
    private Matrix k;
    private int d;
    private int inputDim;

    public Model(Kernel kernel, double[][] basisVectors, Matrix alpha, Matrix C, Matrix Q, int d, boolean regression) {
        this.kernel = kernel;
        this.basisVectors = basisVectors;
        this.alpha = alpha;
        this.regression = regression;
        this.d = d;
        this.inputDim = basisVectors[0].length;
        this.k = new Matrix(d, 1);
    }

    public int getNumberOfBasisVectors() {
        return this.basisVectors.length;
    }

    public int getInputDim() {
        return this.inputDim;
    }

    public double[] getBasisVector(int i) {
        return this.basisVectors[i];
    }

    public double getBasisVectorValue(int i, int j) {
        return this.basisVectors[i][j];
    }

    private double scalarProduct(double[][] x, double[][] y, int d) {
        double result = 0.0;
        int i = 0;
        while (i < d) {
            result += x[i][0] * y[i][0];
            ++i;
        }
        return result;
    }

    public double applyToVector(double[] x_new) {
        double m = 0.0;
        double prediction = 0.0;
        int j = 0;
        while (j < this.d) {
            this.k.getArray()[j][0] = this.kernel.eval(this.basisVectors[j], x_new);
            ++j;
        }
        prediction = m = this.scalarProduct(this.k.getArray(), this.alpha.getArray(), this.d);
        return prediction;
    }

    public double[] apply(double[][] inputVectors) throws Exception {
        double[] prediction = new double[inputVectors.length];
        int i = 0;
        while (i < inputVectors.length) {
            prediction[i] = this.applyToVector(inputVectors[i]);
            if (!this.regression) {
                prediction[i] = prediction[i] > 0.0 ? 1.0 : 0.0;
            }
            ++i;
        }
        return prediction;
    }
}

