/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.evosvm;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.functions.kernel.SupportVector;
import com.rapidminer.operator.learner.functions.kernel.evosvm.EvoOptimization;
import com.rapidminer.operator.learner.functions.kernel.evosvm.EvoSVM;
import com.rapidminer.operator.learner.functions.kernel.evosvm.EvoSVMModel;
import com.rapidminer.operator.learner.functions.kernel.evosvm.OptimizationFunction;
import com.rapidminer.operator.learner.functions.kernel.evosvm.RegressionOptimizationFunction;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.kernels.Kernel;
import com.rapidminer.tools.math.optimization.ec.es.ESOptimization;
import com.rapidminer.tools.math.optimization.ec.es.Individual;
import java.util.ArrayList;
import java.util.Iterator;

public class RegressionEvoOptimization
extends ESOptimization
implements EvoOptimization {
    private ExampleSet exampleSet;
    private Kernel kernel;
    private double[] ys;
    private OptimizationFunction optimizationFunction;

    public RegressionEvoOptimization(ExampleSet exampleSet, Kernel kernel, double c, double epsilon, int initType, int maxIterations, int generationsWithoutImprovement, int popSize, int selectionType, double tournamentFraction, boolean keepBest, int mutationType, double crossoverProb, boolean showConvergencePlot, boolean showPopulationPlot, RandomGenerator random, LoggingHandler logging) {
        super(EvoSVM.createBoundArray(0.0, 2 * exampleSet.size()), EvoSVM.determineMax(c, kernel, exampleSet, selectionType, 2 * exampleSet.size()), popSize, 2 * exampleSet.size(), initType, maxIterations, generationsWithoutImprovement, selectionType, tournamentFraction, keepBest, mutationType, Double.NaN, crossoverProb, showConvergencePlot, showPopulationPlot, random, logging);
        this.exampleSet = exampleSet;
        this.kernel = kernel;
        this.ys = new double[exampleSet.size()];
        Iterator reader = exampleSet.iterator();
        int index = 0;
        while (reader.hasNext()) {
            Example example = (Example)reader.next();
            this.ys[index++] = example.getLabel();
        }
        this.optimizationFunction = new RegressionOptimizationFunction(epsilon);
    }

    public PerformanceVector evaluateIndividual(Individual individual) {
        double[] fitness = this.optimizationFunction.getFitness(individual.getValues(), this.ys, this.kernel);
        PerformanceVector performanceVector = new PerformanceVector();
        performanceVector.addCriterion(new EstimatedPerformance("SVM_fitness", fitness[0], 1, false));
        performanceVector.addCriterion(new EstimatedPerformance("SVM_complexity", fitness[1], 1, false));
        return performanceVector;
    }

    public EvoSVMModel train() throws OperatorException {
        this.optimize();
        return this.getModel(this.getBestValuesEver());
    }

    public PerformanceVector getOptimizationPerformance() {
        double[] bestValuesEver = this.getBestValuesEver();
        double[] finalFitness = this.optimizationFunction.getFitness(bestValuesEver, this.ys, this.kernel);
        PerformanceVector result = new PerformanceVector();
        result.addCriterion(new EstimatedPerformance("svm_objective_function", finalFitness[0], 1, false));
        result.addCriterion(new EstimatedPerformance("no_support_vectors", -1.0 * finalFitness[1], 1, true));
        return result;
    }

    private EvoSVMModel getModel(double[] alphas) {
        Iterator reader = this.exampleSet.iterator();
        ArrayList<SupportVector> supportVectors = new ArrayList<SupportVector>();
        int index = 0;
        while (reader.hasNext()) {
            double currentAlpha = alphas[index];
            Example currentExample = (Example)reader.next();
            if (currentAlpha != 0.0) {
                double[] x = new double[this.exampleSet.getAttributes().size()];
                int a = 0;
                for (Attribute attribute : this.exampleSet.getAttributes()) {
                    x[a++] = currentExample.getValue(attribute);
                }
                supportVectors.add(new SupportVector(x, this.ys[index], currentAlpha));
            }
            ++index;
        }
        double[] sum = new double[this.exampleSet.size()];
        reader = this.exampleSet.iterator();
        index = 0;
        while (reader.hasNext()) {
            Example current = (Example)reader.next();
            double[] x = new double[this.exampleSet.getAttributes().size()];
            int a = 0;
            for (Attribute attribute : this.exampleSet.getAttributes()) {
                x[a++] = current.getValue(attribute);
            }
            sum[index] = this.kernel.getSum(supportVectors, x);
            ++index;
        }
        double bSum = 0.0;
        boolean bCounter = true;
        return new EvoSVMModel(this.exampleSet, supportVectors, this.kernel, bSum / (double)bCounter);
    }
}

