/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearnerCapability {
    public static final LearnerCapability POLYNOMINAL_ATTRIBUTES;
    public static final LearnerCapability BINOMINAL_ATTRIBUTES;
    public static final LearnerCapability NUMERICAL_ATTRIBUTES;
    public static final LearnerCapability POLYNOMINAL_CLASS;
    public static final LearnerCapability BINOMINAL_CLASS;
    public static final LearnerCapability NUMERICAL_CLASS;
    public static final LearnerCapability UPDATABLE;
    public static final LearnerCapability WEIGHTED_EXAMPLES;
    public static final LearnerCapability FORMULA_PROVIDER;
    private static List<LearnerCapability> ALL_CAPABILITIES;
    private String description;

    static {
        ALL_CAPABILITIES = new ArrayList<LearnerCapability>();
        POLYNOMINAL_ATTRIBUTES = new LearnerCapability("polynominal attributes");
        ALL_CAPABILITIES.add(POLYNOMINAL_ATTRIBUTES);
        BINOMINAL_ATTRIBUTES = new LearnerCapability("binominal attributes");
        ALL_CAPABILITIES.add(BINOMINAL_ATTRIBUTES);
        NUMERICAL_ATTRIBUTES = new LearnerCapability("numerical attributes");
        ALL_CAPABILITIES.add(NUMERICAL_ATTRIBUTES);
        POLYNOMINAL_CLASS = new LearnerCapability("polynominal label");
        ALL_CAPABILITIES.add(POLYNOMINAL_CLASS);
        BINOMINAL_CLASS = new LearnerCapability("binominal label");
        ALL_CAPABILITIES.add(BINOMINAL_CLASS);
        NUMERICAL_CLASS = new LearnerCapability("numerical label");
        ALL_CAPABILITIES.add(NUMERICAL_CLASS);
        UPDATABLE = new LearnerCapability("updatable");
        ALL_CAPABILITIES.add(UPDATABLE);
        WEIGHTED_EXAMPLES = new LearnerCapability("weighted examples");
        ALL_CAPABILITIES.add(WEIGHTED_EXAMPLES);
        FORMULA_PROVIDER = new LearnerCapability("formula provider");
        ALL_CAPABILITIES.add(FORMULA_PROVIDER);
    }

    public LearnerCapability(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static LearnerCapability getCapability(int index) {
        return ALL_CAPABILITIES.get(index);
    }

    public static List<LearnerCapability> getAllCapabilities() {
        return ALL_CAPABILITIES;
    }
}

