/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.XMLSerialization;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOContainerWriter
extends Operator {
    public static final String PARAMETER_FILENAME = "filename";
    public static final String PARAMETER_ZIPPED = "zipped";

    public IOContainerWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        File file = this.getParameterAsFile(PARAMETER_FILENAME, true);
        OutputStream out = null;
        try {
            try {
                out = this.getParameterAsBoolean(PARAMETER_ZIPPED) ? new GZIPOutputStream(new FileOutputStream(file)) : new FileOutputStream(file);
                XMLSerialization.getXMLSerialization().writeXML(input, out);
                this.log(String.valueOf(this.getName()) + ": Input IOContainer written to file" + file);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 303, file, e.getMessage());
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + file);
                }
            }
        }
        return new IOObject[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile(PARAMETER_FILENAME, "Name of file to write the output to.", "ioc", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_ZIPPED, "Indicates if the file content should be zipped.", true));
        return types;
    }
}

