/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.IndexCachedDatabaseExampleTable;
import com.rapidminer.gui.wizards.DBExampleSourceConfigurationWizardCreator;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractExampleSource;
import com.rapidminer.operator.io.ResultSetExampleSource;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.DatabaseService;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedDatabaseExampleSource
extends AbstractExampleSource {
    public static final String PARAMETER_RECREATE_INDEX = "recreate_index";
    private DatabaseHandler databaseHandler;

    public CachedDatabaseExampleSource(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet createExampleSet() throws OperatorException {
        try {
            DatabaseHandler databaseHandler = this.getConnectedDatabaseHandler();
            String tableName = this.getParameterAsString("table_name");
            boolean recreateIndex = this.getParameterAsBoolean(PARAMETER_RECREATE_INDEX);
            IndexCachedDatabaseExampleTable table = new IndexCachedDatabaseExampleTable(databaseHandler, tableName, 0, recreateIndex, this);
            return ResultSetExampleSource.createExampleSet(table, this);
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, e.getMessage());
        }
    }

    protected DatabaseHandler getConnectedDatabaseHandler() throws OperatorException, SQLException {
        String databaseURL = this.getParameterAsString("database_url");
        String username = this.getParameterAsString("username");
        String password = this.getParameterAsString("password");
        return DatabaseHandler.getConnectedDatabaseHandler(databaseURL, username, password, DatabaseService.getJDBCProperties().get(this.getParameterAsInt("database_system")), this);
    }

    @Override
    public void processFinished() {
        this.disconnect();
    }

    private void disconnect() {
        if (this.databaseHandler != null) {
            try {
                this.databaseHandler.disconnect();
                this.databaseHandler = null;
            }
            catch (SQLException e) {
                this.logWarning("Cannot disconnect from database: " + e);
            }
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        HashMap<String, String> wizardParameters = new HashMap<String, String>();
        wizardParameters.put("only_table_name", "true");
        wizardParameters.put("show_database_configuration", "true");
        ParameterType type = new ParameterTypeConfiguration(DBExampleSourceConfigurationWizardCreator.class, wizardParameters, this);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("database_system", "Indicates the used database system", DatabaseService.getDBSystemNames(), 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("database_url", "The complete URL connection string for the database, e.g. 'jdbc:mysql://foo.bar:portnr/database'", false));
        types.add(new ParameterTypeString("username", "Database username.", false));
        types.add(new ParameterTypePassword("password", "Password for the database."));
        types.add(new ParameterTypeString("table_name", "Use this table as the base for this data access.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_RECREATE_INDEX, "Indicates if a recreation of the index or index mapping table should be forced.", false));
        type = new ParameterTypeString("label_attribute", "The (case sensitive) name of the label attribute");
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("id_attribute", "The (case sensitive) name of the id attribute"));
        types.add(new ParameterTypeString("weight_attribute", "The (case sensitive) name of the weight attribute"));
        return types;
    }
}

