/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.transformation;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.features.transformation.KernelPCAModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.tools.math.kernels.Kernel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KernelPCA
extends Operator {
    public static final String PARAMETER_KERNEL_TYPE = "kernel_type";
    public static final String PARAMETER_KERNEL_GAMMA = "kernel_gamma";
    public static final String PARAMETER_KERNEL_SIGMA1 = "kernel_sigma1";
    public static final String PARAMETER_KERNEL_SIGMA2 = "kernel_sigma2";
    public static final String PARAMETER_KERNEL_SIGMA3 = "kernel_sigma3";
    public static final String PARAMETER_KERNEL_DEGREE = "kernel_degree";
    public static final String PARAMETER_KERNEL_SHIFT = "kernel_shift";
    public static final String PARAMETER_KERNEL_A = "kernel_a";
    public static final String PARAMETER_KERNEL_B = "kernel_b";
    public static final String PARAMETER_EPSILON = "epsilon";

    public KernelPCA(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = this.getInput(ExampleSet.class);
        Tools.onlyNumericalAttributes(exampleSet, "KernelPCA");
        Tools.onlyNonMissingValues(exampleSet, "KernelPCA");
        Attributes attributes = exampleSet.getAttributes();
        int numberOfExamples = exampleSet.size();
        exampleSet.recalculateAllAttributeStatistics();
        double[] means = new double[exampleSet.getAttributes().size()];
        int i = 0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            means[i] = exampleSet.getStatistics(attribute, "average");
            ++i;
        }
        Kernel kernel = Kernel.createKernel(this);
        ArrayList<double[]> exampleValues = new ArrayList<double[]>(numberOfExamples);
        i = 0;
        for (Example columnExample : exampleSet) {
            double[] columnValues = this.getAttributeValues(columnExample, attributes, means);
            exampleValues.add(columnValues);
            ++i;
        }
        Matrix kernelMatrix = new Matrix(numberOfExamples, numberOfExamples);
        i = 0;
        while (i < numberOfExamples) {
            int j = 0;
            while (j < numberOfExamples) {
                kernelMatrix.set(i, j, kernel.calculateDistance(exampleValues.get(i), exampleValues.get(j)));
                ++j;
            }
            ++i;
        }
        EigenvalueDecomposition eig = kernelMatrix.eig();
        KernelPCAModel model = new KernelPCAModel(exampleSet, means, eig.getV(), exampleValues, kernel);
        return new IOObject[]{exampleSet, model};
    }

    private double[] getAttributeValues(Example example, Attributes attributes, double[] means) {
        double[] values = new double[attributes.size()];
        int x = 0;
        for (Attribute attribute : attributes) {
            values[x] = example.getValue(attribute) - means[x];
            ++x;
        }
        return values;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{ExampleSet.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class, Model.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.addAll(Kernel.getParameters(this));
        return types;
    }
}

