/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features;

import com.rapidminer.operator.features.Individual;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Population {
    public static final Comparator<Individual> PERFORMANCE_COMPARATOR = new Comparator<Individual>(){

        @Override
        public int compare(Individual i1, Individual i2) {
            PerformanceVector p1 = i1.getPerformance();
            PerformanceVector p2 = i2.getPerformance();
            return p1.compareTo(p2);
        }
    };
    private ArrayList<Individual> individuals = new ArrayList();
    private int generation = 0;
    private int generationOfLastImproval = 0;
    private Individual bestEver;
    private PerformanceVector bestPerformanceEver;
    private Individual currentBest;
    private PerformanceVector currentBestPerformance;

    public void clear() {
        this.individuals.clear();
    }

    public void add(Individual individual) {
        this.individuals.add(individual);
    }

    public void addAllIndividuals(Collection<Individual> newIndividuals) {
        this.individuals.addAll(newIndividuals);
    }

    public void remove(Individual individual) {
        this.individuals.remove(individual);
    }

    public void remove(int i) {
        this.individuals.remove(i);
    }

    public Individual get(int i) {
        return this.individuals.get(i);
    }

    public int getNumberOfIndividuals() {
        return this.individuals.size();
    }

    public boolean empty() {
        return this.individuals.size() == 0;
    }

    public void nextGeneration() {
        ++this.generation;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getGenerationsWithoutImproval() {
        return this.generation - this.generationOfLastImproval;
    }

    public void updateEvaluation() {
        this.currentBest = this.searchBest();
        PerformanceVector performanceVector = this.currentBestPerformance = this.currentBest == null ? null : this.currentBest.getPerformance();
        if (this.bestEver == null || this.currentBest != null && this.currentBestPerformance.compareTo(this.bestPerformanceEver) > 0) {
            this.bestEver = new Individual(this.currentBest.getWeights());
            this.bestEver.setPerformance(this.currentBest.getPerformance());
            this.bestPerformanceEver = this.bestEver.getPerformance();
            this.generationOfLastImproval = this.generation;
        }
    }

    private Individual searchBest() {
        try {
            return Collections.max(this.individuals, PERFORMANCE_COMPARATOR);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public PerformanceVector getBestPerformanceEver() {
        return this.bestPerformanceEver;
    }

    public Individual getBestIndividualEver() {
        return this.bestEver;
    }

    public Individual getCurrentBest() {
        return this.currentBest;
    }

    public PerformanceVector getCurrentBestPerformance() {
        return this.currentBestPerformance;
    }

    public void sort() {
        Collections.sort(this.individuals, PERFORMANCE_COMPARATOR);
    }

    public String toString() {
        StringBuffer s = new StringBuffer("Generation: " + this.generation + ",size: " + this.getNumberOfIndividuals() + ", individuals:" + Tools.getLineSeparator());
        int i = 0;
        while (i < this.getNumberOfIndividuals()) {
            if (i > 0) {
                s.append(",");
            }
            s.append(String.valueOf(i) + ": " + Arrays.toString(this.get(i).getWeights()) + Tools.getLineSeparator());
            ++i;
        }
        s.append("]");
        return s.toString();
    }
}

