/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.wizards;

import com.rapidminer.example.Attributes;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ProgressMonitor;
import com.rapidminer.gui.tools.ProgressUtils;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.wizards.AbstractConfigurationWizard;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.gui.wizards.DBExampleSourceConfigurationWizardDataTable;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.jdbc.ColumnIdentifier;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.jdbc.JDBCProperties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DBTableSelectionWizard
extends AbstractConfigurationWizard {
    private static final long serialVersionUID = 1940721394280823666L;
    private static final int DEFAULT_MAX_ROW_NUMBER = 100;
    private static final int STEP_TABLE_SELECTION = 0;
    private static final int STEP_TYPE_DEFINITION = 1;
    private String system;
    private String server;
    private String databaseName;
    private String user;
    private String password;
    private JList tableList = new JList();
    private JList attributeList = new JList();
    private Map<String, List<ColumnIdentifier>> attributeNameMap = new LinkedHashMap<String, List<ColumnIdentifier>>();
    private Map<ColumnIdentifier, String> attributeTypeMap = new HashMap<ColumnIdentifier, String>();
    private DBExampleSourceConfigurationWizardDataTable dataView = new DBExampleSourceConfigurationWizardDataTable();

    public DBTableSelectionWizard(ConfigurationListener listener, String selectedSystem, String server, String databaseName, String user, String password) {
        super("Table Selection Wizard", listener);
        this.system = selectedSystem;
        this.server = server;
        this.databaseName = databaseName;
        this.user = user;
        this.password = password;
        this.addTableSelectionStep();
        this.addSpecialAttributesStep();
        this.retrieveTableAndAttributeNames();
    }

    private void addTableSelectionStep() {
        JPanel panel = SwingTools.createTextPanel("Please select a single table...", "Please specify the table which is the base for this data access.");
        this.tableList.setSelectionMode(0);
        this.tableList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DBTableSelectionWizard.this.updateAttributeNames();
            }
        });
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane(this.tableList);
        tablePane.setBorder(BorderFactory.createTitledBorder("Tables"));
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel content = new JPanel(layout);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(7, 7, 7, 7);
        c.gridwidth = 0;
        layout.setConstraints(tablePane, c);
        content.add(tablePane);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void addSpecialAttributesStep() {
        JPanel panel = SwingTools.createTextPanel("Please define special attributes...", "Please define which columns should be used as special attributes like labels or Ids (if any). After pressing finish the necessary settings will be made for the operator.");
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(7, 7, 7, 7);
        JPanel content = new JPanel(layout);
        ExtendedJScrollPane typeViewPane = new ExtendedJScrollPane(this.dataView);
        typeViewPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7), BorderFactory.createTitledBorder("Data and Attribute Types View (Sample)")));
        layout.setConstraints(typeViewPane, c);
        content.add(typeViewPane);
        panel.add((Component)content, "Center");
        this.addStep(panel);
    }

    private void retrieveTableAndAttributeNames() {
        try {
            JDBCProperties databaseProps = DatabaseService.getJDBCProperties(this.system);
            final DatabaseHandler handler = DatabaseHandler.getConnectedDatabaseHandler(String.valueOf(databaseProps.getUrlPrefix()) + this.server + databaseProps.getDbNameSeperator() + this.databaseName, this.user, this.password, databaseProps, null);
            Thread retrieveTablesThread = new Thread(){

                public void run() {
                    ProgressMonitor monitor = ProgressUtils.createProgressMonitor(DBTableSelectionWizard.this, 100, true, 50, true);
                    monitor.start("Fetching tables and attributes from database...");
                    try {
                        DBTableSelectionWizard.this.attributeNameMap.clear();
                        if (handler != null) {
                            try {
                                Map<String, List<ColumnIdentifier>> newAttributeMap = handler.getAllTableMetaData();
                                DBTableSelectionWizard.this.attributeNameMap.putAll(newAttributeMap);
                            }
                            catch (SQLException e) {
                                DBTableSelectionWizard.this.showSQLError("Retrieval of table and attribute names failed", e);
                            }
                        }
                        String[] allNames = new String[DBTableSelectionWizard.this.attributeNameMap.size()];
                        DBTableSelectionWizard.this.attributeNameMap.keySet().toArray(allNames);
                        DBTableSelectionWizard.this.tableList.removeAll();
                        DBTableSelectionWizard.this.tableList.setListData(allNames);
                    }
                    finally {
                        if (monitor.getCurrent() != monitor.getTotal()) {
                            monitor.setCurrent(null, monitor.getTotal());
                        }
                        try {
                            handler.disconnect();
                        }
                        catch (SQLException e) {
                            DBTableSelectionWizard.this.showSQLError("Disconnecting from the database failed", e);
                        }
                    }
                }
            };
            retrieveTablesThread.start();
        }
        catch (Exception e1) {
            this.showSQLError("Could not connect to database", e1);
        }
    }

    private void updateDataView() throws SQLException {
        ColumnIdentifier currentColumn;
        int i;
        this.attributeTypeMap.clear();
        Object[] attributeSelection = this.attributeList.getSelectedValues();
        ColumnIdentifier[] usedAttributes = null;
        if (attributeSelection.length == 0) {
            usedAttributes = new ColumnIdentifier[this.attributeList.getModel().getSize()];
            i = 0;
            while (i < this.attributeList.getModel().getSize()) {
                usedAttributes[i] = currentColumn = (ColumnIdentifier)this.attributeList.getModel().getElementAt(i);
                this.attributeTypeMap.put(currentColumn, "attribute");
                ++i;
            }
        } else {
            usedAttributes = new ColumnIdentifier[attributeSelection.length];
            i = 0;
            while (i < attributeSelection.length) {
                usedAttributes[i] = currentColumn = (ColumnIdentifier)attributeSelection[i];
                this.attributeTypeMap.put(currentColumn, "attribute");
                ++i;
            }
        }
        LinkedList<String[]> data = new LinkedList<String[]>();
        try {
            JDBCProperties databaseProps = DatabaseService.getJDBCProperties(this.system);
            DatabaseHandler handler = DatabaseHandler.getConnectedDatabaseHandler(String.valueOf(databaseProps.getUrlPrefix()) + this.server + databaseProps.getDbNameSeperator() + this.databaseName, this.user, this.password, databaseProps, null);
            if (handler != null) {
                Statement statement = handler.createStatement(false);
                statement.setMaxRows(100);
                String query = "SELECT * FROM " + databaseProps.getIdentifierQuoteOpen() + this.tableList.getSelectedValue() + databaseProps.getIdentifierQuoteClose();
                ResultSet resultSet = statement.executeQuery(query);
                int counter = 0;
                while (resultSet.next() && counter < 100) {
                    String[] row = new String[usedAttributes.length];
                    int c = 0;
                    while (c < row.length) {
                        row[c] = resultSet.getString(c + 1);
                        ++c;
                    }
                    data.add(row);
                    ++counter;
                }
                resultSet.close();
                statement.close();
            }
            handler.disconnect();
        }
        catch (Exception e1) {
            this.showSQLError("Could not connect to database", e1);
        }
        this.dataView.update(usedAttributes, data, this.attributeTypeMap);
    }

    private void updateAttributeNames() {
        Object[] selection;
        LinkedList<ColumnIdentifier> allColumnIdentifiers = new LinkedList<ColumnIdentifier>();
        Object[] objectArray = selection = this.tableList.getSelectedValues();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            String tableName = (String)o;
            List<ColumnIdentifier> attributeNames = this.attributeNameMap.get(tableName);
            if (attributeNames != null) {
                for (ColumnIdentifier currentIdentifier : attributeNames) {
                    allColumnIdentifiers.add(currentIdentifier);
                }
            }
            ++n2;
        }
        this.attributeList.removeAll();
        ColumnIdentifier[] identifierArray = new ColumnIdentifier[allColumnIdentifiers.size()];
        allColumnIdentifiers.toArray(identifierArray);
        this.attributeList.setListData(identifierArray);
    }

    protected void finish(ConfigurationListener listener) {
        Parameters parameters = listener.getParameters();
        String tableName = this.tableList.getSelectedValue().toString();
        parameters.setParameter("table_name", tableName);
        parameters.setParameter("label_attribute", null);
        parameters.setParameter("id_attribute", null);
        parameters.setParameter("weight_attribute", null);
        int i = 1;
        while (i < Attributes.KNOWN_ATTRIBUTE_TYPES.length) {
            this.ensureAttributeTypeIsUnique(Attributes.KNOWN_ATTRIBUTE_TYPES[i]);
            ++i;
        }
        boolean singleTable = this.tableList.getSelectedValues().length == 1;
        for (ColumnIdentifier attributeIdentifier : this.attributeTypeMap.keySet()) {
            String attType = this.attributeTypeMap.get(attributeIdentifier);
            String maskedAttributeName = attributeIdentifier.getAliasName(DatabaseService.getJDBCProperties(this.system), singleTable);
            maskedAttributeName = maskedAttributeName.substring(1, maskedAttributeName.length() - 1);
            if (attType.equals("label")) {
                parameters.setParameter("label_attribute", maskedAttributeName);
                continue;
            }
            if (attType.equals("id")) {
                parameters.setParameter("id_attribute", maskedAttributeName);
                continue;
            }
            if (!attType.equals("weight")) continue;
            parameters.setParameter("weight_attribute", maskedAttributeName);
        }
        listener.setParameters(parameters);
        this.dispose();
        RapidMinerGUI.getMainFrame().getPropertyTable().refresh();
    }

    protected void performStepAction(int currentStep, int oldStep) {
        if (currentStep == 0) {
            if (oldStep < currentStep) {
                this.retrieveTableAndAttributeNames();
            }
        } else if (currentStep == 1) {
            try {
                this.updateDataView();
            }
            catch (SQLException e) {
                this.showConnectionError("Cannot retrieve sample data", e);
            }
        }
    }

    private void ensureAttributeTypeIsUnique(String type) {
        LinkedList<ColumnIdentifier> columns = new LinkedList<ColumnIdentifier>();
        LinkedList<Integer> columnNumbers = new LinkedList<Integer>();
        Iterator<ColumnIdentifier> i = this.attributeTypeMap.keySet().iterator();
        int j = 0;
        while (i.hasNext()) {
            ColumnIdentifier attributeIdentifier = i.next();
            String attType = this.attributeTypeMap.get(attributeIdentifier);
            if (attType.equals(type)) {
                columns.add(attributeIdentifier);
                columnNumbers.add(j);
            }
            ++j;
        }
        if (columns.size() > 1) {
            Object[] identifiers = new ColumnIdentifier[columns.size()];
            columns.toArray(identifiers);
            JTextArea message = new JTextArea("The special attribute " + type + " is multiply defined. Please select one of the data columns (others will be changed to regular attributes). Press \"Cancel\" to ignore.", 4, 40);
            message.setEditable(false);
            message.setLineWrap(true);
            message.setWrapStyleWord(true);
            message.setBackground(new JLabel("").getBackground());
            ColumnIdentifier selection = (ColumnIdentifier)JOptionPane.showInputDialog(this, message, String.valueOf(type) + " multiply defined", 2, null, identifiers, identifiers[0]);
            if (selection != null) {
                for (ColumnIdentifier name : columns) {
                    if (name.equals(selection)) continue;
                    this.attributeTypeMap.remove(name);
                    this.attributeTypeMap.put(name, "attribute");
                }
            }
        }
    }

    private void showSQLError(String message, Exception e) {
        JOptionPane.showMessageDialog(this, String.valueOf(message != null ? String.valueOf(message) + ": " : "") + e.getMessage(), "SQL Error", 0);
    }

    private void showConnectionError(String message, SQLException e) {
        JOptionPane.showMessageDialog(this, String.valueOf(message != null ? String.valueOf(message) + ": " : "") + "Connection to database has failed:" + Tools.getLineSeparator() + e.getMessage().substring(0, Math.min(300, e.getMessage().length())) + "...", "Connection failed", 0);
    }
}

