/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.set.PartitionBuilder;
import com.rapidminer.tools.LogService;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;

public class Partition
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6126334515107973287L;
    private boolean[] mask;
    private int[] partitionSizes;
    private int[] elements;
    private int[] lastElementIndex;
    private int[] tableIndexMap = null;

    public Partition(double[] ratio, int size, PartitionBuilder builder) {
        this.init(ratio, size, builder);
    }

    public Partition(int noPartitions, int size, PartitionBuilder builder) {
        double[] ratio = new double[noPartitions];
        int i = 0;
        while (i < ratio.length) {
            ratio[i] = 1.0 / (double)noPartitions;
            ++i;
        }
        this.init(ratio, size, builder);
    }

    public Partition(int[] elements, int numberOfPartitions) {
        this.init(elements, numberOfPartitions);
    }

    private Partition(Partition p) {
        this.partitionSizes = new int[p.partitionSizes.length];
        System.arraycopy(p.partitionSizes, 0, this.partitionSizes, 0, p.partitionSizes.length);
        this.mask = new boolean[p.mask.length];
        System.arraycopy(p.mask, 0, this.mask, 0, p.mask.length);
        this.elements = new int[p.elements.length];
        System.arraycopy(p.elements, 0, this.elements, 0, p.elements.length);
        this.lastElementIndex = new int[p.lastElementIndex.length];
        System.arraycopy(p.lastElementIndex, 0, this.lastElementIndex, 0, p.lastElementIndex.length);
        this.recalculateTableIndices();
    }

    private void init(double[] ratio, int size, PartitionBuilder builder) {
        LogService.getGlobal().log("Create new partition using a '" + builder.getClass().getName() + "'.", 2);
        this.elements = builder.createPartition(ratio, size);
        this.init(this.elements, ratio.length);
    }

    private void init(int[] newElements, int noOfPartitions) {
        LogService.getGlobal().log("Create new partition with " + newElements.length + " elements and " + noOfPartitions + " partitions.", 2);
        this.partitionSizes = new int[noOfPartitions];
        this.lastElementIndex = new int[noOfPartitions];
        this.elements = newElements;
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i] >= 0) {
                int n = this.elements[i];
                this.partitionSizes[n] = this.partitionSizes[n] + 1;
                this.lastElementIndex[this.elements[i]] = i;
            }
            ++i;
        }
        this.mask = new boolean[noOfPartitions];
        i = 0;
        while (i < this.mask.length) {
            this.mask[i] = true;
            ++i;
        }
        this.recalculateTableIndices();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Partition)) {
            return false;
        }
        Partition other = (Partition)o;
        int i = 0;
        while (i < this.mask.length) {
            if (this.mask[i] != other.mask[i]) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.elements.length) {
            if (this.elements[i] != other.elements[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + this.mask.length;
        int i = 1;
        while (i < this.mask.length) {
            hc = hc * hashMultiplier + Boolean.valueOf(this.mask[i]).hashCode();
            i <<= 1;
        }
        hc = hc * hashMultiplier + this.elements.length;
        i = 1;
        while (i < this.elements.length) {
            hc = hc * hashMultiplier + Integer.valueOf(this.elements[i]).hashCode();
            i <<= 1;
        }
        return hc;
    }

    public boolean hasNext(int index) {
        int p = 0;
        while (p < this.mask.length) {
            if (this.mask[p] && index <= this.lastElementIndex[p]) {
                return true;
            }
            ++p;
        }
        return false;
    }

    public void clearSelection() {
        this.mask = new boolean[this.mask.length];
        this.recalculateTableIndices();
    }

    public void invertSelection() {
        int i = 0;
        while (i < this.mask.length) {
            this.mask[i] = !this.mask[i];
            ++i;
        }
        this.recalculateTableIndices();
    }

    public void selectSubset(int i) {
        this.mask[i] = true;
        this.recalculateTableIndices();
    }

    public void deselectSubset(int i) {
        this.mask[i] = false;
        this.recalculateTableIndices();
    }

    public int getNumberOfSubsets() {
        return this.partitionSizes.length;
    }

    public int getSelectionSize() {
        int s = 0;
        int i = 0;
        while (i < this.partitionSizes.length) {
            if (this.mask[i]) {
                s += this.partitionSizes[i];
            }
            ++i;
        }
        return s;
    }

    public int getTotalSize() {
        return this.elements.length;
    }

    public boolean isSelected(int index) {
        return this.mask[this.elements[index]];
    }

    private void recalculateTableIndices() {
        LinkedList<Integer> indices = new LinkedList<Integer>();
        int i = 0;
        while (i < this.elements.length) {
            if (this.mask[this.elements[i]]) {
                indices.add(i);
            }
            ++i;
        }
        this.tableIndexMap = new int[indices.size()];
        Iterator i2 = indices.iterator();
        int counter = 0;
        while (i2.hasNext()) {
            this.tableIndexMap[counter++] = (Integer)i2.next();
        }
    }

    public int mapIndex(int index) {
        return this.tableIndexMap[index];
    }

    public String toString() {
        StringBuffer str = new StringBuffer("(");
        int i = 0;
        while (i < this.partitionSizes.length) {
            str.append(String.valueOf(i != 0 ? "/" : "") + this.partitionSizes[i]);
            ++i;
        }
        str.append(")");
        return str.toString();
    }

    public Object clone() {
        return new Partition(this);
    }
}

