/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.aggregation;

import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AverageFunction;
import com.rapidminer.tools.math.function.aggregation.CountFunction;
import com.rapidminer.tools.math.function.aggregation.MaxFunction;
import com.rapidminer.tools.math.function.aggregation.MedianFunction;
import com.rapidminer.tools.math.function.aggregation.MinFunction;
import com.rapidminer.tools.math.function.aggregation.ModeFunction;
import com.rapidminer.tools.math.function.aggregation.StandardDeviationFunction;
import com.rapidminer.tools.math.function.aggregation.SumFunction;
import com.rapidminer.tools.math.function.aggregation.VarianceFunction;
import java.lang.reflect.InvocationTargetException;

public abstract class AbstractAggregationFunction
implements AggregationFunction {
    public static final Class[] KNOWN_AGGREGATION_FUNCTIONS = new Class[]{AverageFunction.class, VarianceFunction.class, StandardDeviationFunction.class, CountFunction.class, MinFunction.class, MaxFunction.class, SumFunction.class, ModeFunction.class, MedianFunction.class};
    public static final String[] KNOWN_AGGREGATION_FUNCTION_NAMES = new String[]{"average", "variance", "standard_deviation", "count", "minimum", "maximum", "sum", "mode", "median"};
    public static final int AVERAGE = 0;
    public static final int VARIANCE = 1;
    public static final int STANDARD_DEVIATION = 2;
    public static final int COUNT = 3;
    public static final int MINIMUM = 4;
    public static final int MAXIMUM = 5;
    public static final int SUM = 6;
    public static final int MODE = 7;
    public static final int MEDIAN = 8;
    public static final boolean DEFAULT_IGNORE_MISSINGS = true;
    protected boolean ignoreMissings = true;
    protected boolean foundMissing = false;

    public static AggregationFunction createAggregationFunction(String functionName, boolean ignoreMissings) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        int typeIndex = -1;
        int i = 0;
        while (i < KNOWN_AGGREGATION_FUNCTION_NAMES.length) {
            if (KNOWN_AGGREGATION_FUNCTION_NAMES[i].equals(functionName)) {
                typeIndex = i;
                break;
            }
            ++i;
        }
        Class clazz = null;
        clazz = typeIndex < 0 ? Class.forName(functionName) : KNOWN_AGGREGATION_FUNCTIONS[typeIndex];
        return (AggregationFunction)clazz.getConstructor(Boolean.class).newInstance(ignoreMissings);
    }

    public static AggregationFunction createAggregationFunction(String functionName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        return AbstractAggregationFunction.createAggregationFunction(functionName, true);
    }

    public static AggregationFunction createAggregationFunction(int typeIndex, boolean ignoreMissings) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (typeIndex >= 0 && typeIndex < KNOWN_AGGREGATION_FUNCTION_NAMES.length) {
            Class clazz = KNOWN_AGGREGATION_FUNCTIONS[typeIndex];
            return (AggregationFunction)clazz.getConstructor(Boolean.class).newInstance(ignoreMissings);
        }
        throw new InstantiationException();
    }

    public static AggregationFunction createAggregationFunction(int typeIndex) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return AbstractAggregationFunction.createAggregationFunction(typeIndex, true);
    }

    public AbstractAggregationFunction() {
        this(true);
    }

    public AbstractAggregationFunction(Boolean ignoreMissings) {
        this.ignoreMissings = ignoreMissings;
        this.foundMissing = false;
        this.reset();
    }

    protected abstract void reset();

    public double calculate(double[] values) {
        this.reset();
        int i = 0;
        while (i < values.length) {
            this.update(values[i]);
            ++i;
        }
        return this.getValue();
    }

    public double calculate(double[] values, double[] weights) {
        this.reset();
        if (values.length != weights.length) {
            return Double.NaN;
        }
        int i = 0;
        while (i < values.length) {
            this.update(values[i], weights[i]);
            ++i;
        }
        return this.getValue();
    }
}

